/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HackPushNegotiateHook
implements AdvertiseRefsHook {
    private static final Logger log = LoggerFactory.getLogger(HackPushNegotiateHook.class);
    private static final int HAVE_LINE_LEN = 51;
    private static final int MAX_EXTRA_BYTES = 8192;
    private static final int BASE_COMMITS = 64;
    private static final int STEP_COMMITS = 16;
    private static final int MAX_HISTORY = 160;

    @Override
    public void advertiseRefs(UploadPack us) {
        throw new UnsupportedOperationException("HackPushNegotiateHook cannot be used for UploadPack");
    }

    @Override
    public void advertiseRefs(BaseReceivePack rp) throws ServiceMayNotContinueException {
        Map<String, Ref> r = rp.getAdvertisedRefs();
        if (r == null) {
            try {
                r = rp.getRepository().getRefDatabase().getRefs("");
            }
            catch (ServiceMayNotContinueException e) {
                throw e;
            }
            catch (IOException e) {
                ServiceMayNotContinueException ex = new ServiceMayNotContinueException();
                ex.initCause(e);
                throw ex;
            }
        }
        rp.setAdvertisedRefs(r, this.history(r.values(), rp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ObjectId> history(Collection<Ref> refs, BaseReceivePack rp) {
        int max;
        Set<ObjectId> alreadySending = rp.getAdvertisedObjects();
        if (alreadySending.isEmpty()) {
            alreadySending = HackPushNegotiateHook.idsOf(refs);
        }
        if ((max = 160 - Math.max(0, alreadySending.size() - refs.size())) <= 0) {
            return Collections.emptySet();
        }
        RevWalk rw = rp.getRevWalk();
        rw.reset();
        try {
            for (Ref ref : refs) {
                try {
                    if (ref.getObjectId() == null) continue;
                    rw.markStart(rw.parseCommit(ref.getObjectId()));
                }
                catch (IOException badCommit) {}
            }
            HashSet<ObjectId> history = Sets.newHashSetWithExpectedSize(max);
            try {
                RevCommit c;
                int stepCnt = 0;
                while (history.size() < max && (c = rw.next()) != null) {
                    if (c.getParentCount() > 1 || alreadySending.contains(c) || history.size() >= 64 && ++stepCnt % 16 != 0) continue;
                    history.add(c);
                }
            }
            catch (IOException err) {
                log.error("error trying to advertise history", err);
            }
            HashSet<ObjectId> hashSet = history;
            return hashSet;
        }
        finally {
            rw.reset();
        }
    }

    private static Set<ObjectId> idsOf(Collection<Ref> refs) {
        HashSet<ObjectId> r = Sets.newHashSetWithExpectedSize(refs.size());
        for (Ref ref : refs) {
            if (ref.getObjectId() == null) continue;
            r.add(ref.getObjectId());
        }
        return r;
    }
}

