/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.mail.Address;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class NotifyConfig
implements Comparable<NotifyConfig> {
    private String name;
    private EnumSet<WatchConfig.NotifyType> types = EnumSet.of(WatchConfig.NotifyType.ALL);
    private String filter;
    private Header header;
    private Set<GroupReference> groups = new HashSet<GroupReference>();
    private Set<Address> addresses = new HashSet<Address>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNotify(WatchConfig.NotifyType type) {
        return this.types.contains((Object)type) || this.types.contains((Object)WatchConfig.NotifyType.ALL);
    }

    public EnumSet<WatchConfig.NotifyType> getNotify() {
        return this.types;
    }

    public void setTypes(EnumSet<WatchConfig.NotifyType> newTypes) {
        this.types = EnumSet.copyOf(newTypes);
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = "*".equals(filter) ? null : Strings.emptyToNull(filter);
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header hdr) {
        this.header = hdr;
    }

    public Set<GroupReference> getGroups() {
        return this.groups;
    }

    public Set<Address> getAddresses() {
        return this.addresses;
    }

    public void addEmail(GroupReference group) {
        this.groups.add(group);
    }

    public void addEmail(Address address) {
        this.addresses.add(address);
    }

    @Override
    public int compareTo(NotifyConfig o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NotifyConfig) {
            return this.compareTo((NotifyConfig)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return "NotifyConfig[" + this.name + " = " + this.addresses + " + " + this.groups + "]";
    }

    public static enum Header {
        TO,
        CC,
        BCC;

    }
}

