/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

public enum CommitMergeStatus {
    CLEAN_MERGE("Change has been successfully merged"),
    CLEAN_PICK("Change has been successfully cherry-picked"),
    CLEAN_REBASE("Change has been successfully rebased and submitted"),
    ALREADY_MERGED(""),
    PATH_CONFLICT("Change could not be merged due to a path conflict.\n\nPlease rebase the change locally and upload the rebased commit for review."),
    REBASE_MERGE_CONFLICT("Change could not be merged due to a conflict.\n\nPlease rebase the change locally and upload the rebased commit for review."),
    SKIPPED_IDENTICAL_TREE("Marking change merged without cherry-picking to branch, as the resulting commit would be empty."),
    MISSING_DEPENDENCY(""),
    MANUAL_RECURSIVE_MERGE("The change requires a local merge to resolve.\n\nPlease merge (or rebase) the change locally and upload the resolution for review."),
    CANNOT_CHERRY_PICK_ROOT("Cannot cherry-pick an initial commit onto an existing branch.\n\nPlease merge the change locally and upload the merge commit for review."),
    CANNOT_REBASE_ROOT("Cannot rebase an initial commit onto an existing branch.\n\nPlease merge the change locally and upload the merge commit for review."),
    NOT_FAST_FORWARD("Project policy requires all submissions to be a fast-forward.\n\nPlease rebase the change locally and upload again for review.");

    private final String message;

    private CommitMergeStatus(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }
}

