/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeRevisionNote;
import com.google.gerrit.server.notedb.RevisionNote;
import com.google.gerrit.server.notedb.RobotCommentsRevisionNote;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;

class RevisionNoteMap<T extends RevisionNote<? extends Comment>> {
    final NoteMap noteMap;
    final ImmutableMap<RevId, T> revisionNotes;

    static RevisionNoteMap<ChangeRevisionNote> parse(ChangeNoteUtil noteUtil, Change.Id changeId, ObjectReader reader, NoteMap noteMap, PatchLineComment.Status status) throws ConfigInvalidException, IOException {
        HashMap<RevId, ChangeRevisionNote> result = new HashMap<RevId, ChangeRevisionNote>();
        for (Note note : noteMap) {
            ChangeRevisionNote rn = new ChangeRevisionNote(noteUtil, changeId, reader, note.getData(), status);
            rn.parse();
            result.put(new RevId(note.name()), rn);
        }
        return new RevisionNoteMap<ChangeRevisionNote>(noteMap, ImmutableMap.copyOf(result));
    }

    static RevisionNoteMap<RobotCommentsRevisionNote> parseRobotComments(ChangeNoteUtil noteUtil, ObjectReader reader, NoteMap noteMap) throws ConfigInvalidException, IOException {
        HashMap<RevId, RobotCommentsRevisionNote> result = new HashMap<RevId, RobotCommentsRevisionNote>();
        for (Note note : noteMap) {
            RobotCommentsRevisionNote rn = new RobotCommentsRevisionNote(noteUtil, reader, note.getData());
            rn.parse();
            result.put(new RevId(note.name()), rn);
        }
        return new RevisionNoteMap<RobotCommentsRevisionNote>(noteMap, ImmutableMap.copyOf(result));
    }

    static <T extends RevisionNote<? extends Comment>> RevisionNoteMap<T> emptyMap() {
        return new RevisionNoteMap(NoteMap.newEmptyMap(), ImmutableMap.of());
    }

    private RevisionNoteMap(NoteMap noteMap, ImmutableMap<RevId, T> revisionNotes) {
        this.noteMap = noteMap;
        this.revisionNotes = revisionNotes;
    }
}

