/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.client.RobotComment;
import com.google.gerrit.server.notedb.AbstractChangeNotes;
import com.google.gerrit.server.notedb.ChangeNotesCommit;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.RevisionNoteMap;
import com.google.gerrit.server.notedb.RobotCommentsRevisionNote;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.notes.NoteMap;

public class RobotCommentNotes
extends AbstractChangeNotes<RobotCommentNotes> {
    private final Change change;
    private ImmutableListMultimap<RevId, RobotComment> comments;
    private RevisionNoteMap<RobotCommentsRevisionNote> revisionNoteMap;
    private ObjectId metaId;

    @Inject
    RobotCommentNotes(AbstractChangeNotes.Args args, @Assisted Change change) {
        super(args, change.getId(), NoteDbChangeState.PrimaryStorage.of(change), false);
        this.change = change;
    }

    RevisionNoteMap<RobotCommentsRevisionNote> getRevisionNoteMap() {
        return this.revisionNoteMap;
    }

    public ImmutableListMultimap<RevId, RobotComment> getComments() {
        return this.comments;
    }

    public boolean containsComment(RobotComment c) {
        for (RobotComment existing : this.comments.values()) {
            if (!c.key.equals(existing.key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getRefName() {
        return RefNames.robotCommentsRef(this.getChangeId());
    }

    @Nullable
    public ObjectId getMetaId() {
        return this.metaId;
    }

    @Override
    protected void onLoad(AbstractChangeNotes.LoadHandle handle) throws IOException, ConfigInvalidException {
        this.metaId = handle.id();
        if (this.metaId == null) {
            this.loadDefaults();
            return;
        }
        this.metaId = this.metaId.copy();
        ChangeNotesCommit tipCommit = handle.walk().parseCommit(this.metaId);
        ObjectReader reader = handle.walk().getObjectReader();
        this.revisionNoteMap = RevisionNoteMap.parseRobotComments(this.args.noteUtil, reader, NoteMap.read(reader, tipCommit));
        Multimap cs = MultimapBuilder.hashKeys().arrayListValues().build();
        for (RobotCommentsRevisionNote rn : this.revisionNoteMap.revisionNotes.values()) {
            for (RobotComment c : rn.getComments()) {
                cs.put(new RevId(c.revId), c);
            }
        }
        this.comments = ImmutableListMultimap.copyOf(cs);
    }

    @Override
    protected void loadDefaults() {
        this.comments = ImmutableListMultimap.of();
    }

    @Override
    public Project.NameKey getProjectName() {
        return this.change.getProject();
    }

    public static interface Factory {
        public RobotCommentNotes create(Change var1);
    }
}

