/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilderImpl;
import com.google.gerrit.server.notedb.rebuild.Event;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevWalk;

class PatchSetEvent
extends Event {
    private final Change change;
    private final PatchSet ps;
    private final RevWalk rw;
    boolean createChange;

    PatchSetEvent(Change change, PatchSet ps, RevWalk rw) {
        super(ps.getId(), ps.getUploader(), ps.getUploader(), ps.getCreatedOn(), change.getCreatedOn(), null);
        this.change = change;
        this.ps = ps;
        this.rw = rw;
    }

    @Override
    boolean uniquePerUpdate() {
        return true;
    }

    @Override
    void apply(ChangeUpdate update) throws IOException, OrmException {
        this.checkUpdate(update);
        if (this.createChange) {
            ChangeRebuilderImpl.createChange(update, this.change);
        } else {
            update.setSubject(this.change.getSubject());
            update.setSubjectForCommit("Create patch set " + this.ps.getPatchSetId());
        }
        this.setRevision(update, this.ps);
        update.setPsDescription(this.ps.getDescription());
        List<String> groups = this.ps.getGroups();
        if (!groups.isEmpty()) {
            update.setGroups(this.ps.getGroups());
        }
    }

    private void setRevision(ChangeUpdate update, PatchSet ps) throws IOException {
        ObjectId id;
        String rev = ps.getRevision().get();
        String cert = ps.getPushCertificate();
        try {
            id = ObjectId.fromString(rev);
        }
        catch (InvalidObjectIdException e) {
            update.setRevisionForMissingCommit(rev, cert);
            return;
        }
        try {
            update.setCommit(this.rw, id, cert);
        }
        catch (MissingObjectException e) {
            update.setRevisionForMissingCommit(rev, cert);
            return;
        }
    }
}

