/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.patch.DiffSummary;
import com.google.gerrit.server.patch.DiffSummaryKey;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;

public class DiffSummaryLoader
implements Callable<DiffSummary> {
    private final PatchListCache patchListCache;
    private final DiffSummaryKey key;
    private final Project.NameKey project;

    @Inject
    DiffSummaryLoader(PatchListCache plc, @Assisted DiffSummaryKey k, @Assisted Project.NameKey p) {
        this.patchListCache = plc;
        this.key = k;
        this.project = p;
    }

    @Override
    public DiffSummary call() throws Exception {
        PatchList patchList = this.patchListCache.get(this.key.toPatchListKey(), this.project);
        return this.toDiffSummary(patchList);
    }

    private DiffSummary toDiffSummary(PatchList patchList) {
        ArrayList<String> r = new ArrayList<String>(patchList.getPatches().size());
        for (PatchListEntry e : patchList.getPatches()) {
            if (Patch.isMagic(e.getNewName())) continue;
            switch (e.getChangeType()) {
                case ADDED: 
                case MODIFIED: 
                case DELETED: 
                case COPIED: 
                case REWRITE: {
                    r.add(e.getNewName());
                    break;
                }
                case RENAMED: {
                    r.add(e.getOldName());
                    r.add(e.getNewName());
                }
            }
        }
        Collections.sort(r);
        return new DiffSummary(r.toArray(new String[r.size()]), patchList.getInsertions(), patchList.getDeletions());
    }

    public static interface Factory {
        public DiffSummaryLoader create(DiffSummaryKey var1, Project.NameKey var2);
    }
}

