/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.PluginContentScanner;
import com.google.gerrit.server.plugins.PluginEntry;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.jgit.util.IO;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarScanner
implements PluginContentScanner,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(JarScanner.class);
    private static final int SKIP_ALL = 7;
    private final JarFile jarFile;

    public JarScanner(Path src) throws IOException {
        this.jarFile = new JarFile(src.toFile());
    }

    @Override
    public Map<Class<? extends Annotation>, Iterable<PluginContentScanner.ExtensionMetaData>> scan(String pluginName, Iterable<Class<? extends Annotation>> annotations) throws InvalidPluginException {
        HashSet<String> descriptors = new HashSet<String>();
        Multimap rawMap = MultimapBuilder.hashKeys().arrayListValues().build();
        HashMap<Class<? extends Annotation>, String> classObjToClassDescr = new HashMap<Class<? extends Annotation>, String>();
        for (Class<? extends Annotation> annotation : annotations) {
            String descriptor = Type.getType(annotation).getDescriptor();
            descriptors.add(descriptor);
            classObjToClassDescr.put(annotation, descriptor);
        }
        Enumeration<JarEntry> e = this.jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (JarScanner.skip(entry)) continue;
            ClassData def = new ClassData(descriptors);
            try {
                new ClassReader(JarScanner.read(this.jarFile, entry)).accept(def, 7);
            }
            catch (IOException err) {
                throw new InvalidPluginException("Cannot auto-register", err);
            }
            catch (RuntimeException err) {
                log.warn("Plugin {} has invalid class file {} inside of {}", pluginName, entry.getName(), this.jarFile.getName(), err);
                continue;
            }
            if (Strings.isNullOrEmpty(def.annotationName)) continue;
            if (def.isConcrete()) {
                rawMap.put(def.annotationName, def);
                continue;
            }
            log.warn("Plugin {} tries to @{}(\"{}\") abstract class {}", pluginName, def.annotationName, def.annotationValue, def.className);
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Class<? extends Annotation> annotoation : annotations) {
            String descr = (String)classObjToClassDescr.get(annotoation);
            Collection discoverdData = rawMap.get(descr);
            Collection values = MoreObjects.firstNonNull(discoverdData, Collections.emptySet());
            result.put(annotoation, Iterables.transform(values, cd -> new PluginContentScanner.ExtensionMetaData(cd.className, cd.annotationValue)));
        }
        return result.build();
    }

    public List<String> findSubClassesOf(Class<?> superClass) throws IOException {
        return this.findSubClassesOf(superClass.getName());
    }

    @Override
    public void close() throws IOException {
        this.jarFile.close();
    }

    private List<String> findSubClassesOf(String superClass) throws IOException {
        String name = superClass.replace('.', '/');
        ArrayList<String> classes = new ArrayList<String>();
        Enumeration<JarEntry> e = this.jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (JarScanner.skip(entry)) continue;
            ClassData def = new ClassData(Collections.emptySet());
            try {
                new ClassReader(JarScanner.read(this.jarFile, entry)).accept(def, 7);
            }
            catch (RuntimeException err) {
                log.warn("Jar {} has invalid class file {}", this.jarFile.getName(), entry.getName(), err);
                continue;
            }
            if (!name.equals(def.superName)) continue;
            classes.addAll(this.findSubClassesOf(def.className));
            if (!def.isConcrete()) continue;
            classes.add(def.className);
        }
        return classes;
    }

    private static boolean skip(JarEntry entry) {
        if (!entry.getName().endsWith(".class")) {
            return true;
        }
        if (entry.getSize() <= 0L) {
            return true;
        }
        return entry.getSize() >= 0x100000L;
    }

    private static byte[] read(JarFile jarFile, JarEntry entry) throws IOException {
        byte[] data = new byte[(int)entry.getSize()];
        try (InputStream in = jarFile.getInputStream(entry);){
            IO.readFully(in, data, 0, data.length);
        }
        return data;
    }

    @Override
    public Optional<PluginEntry> getEntry(String resourcePath) throws IOException {
        JarEntry jarEntry = this.jarFile.getJarEntry(resourcePath);
        if (jarEntry == null || jarEntry.getSize() == 0L) {
            return Optional.empty();
        }
        return Optional.of(this.resourceOf(jarEntry));
    }

    @Override
    public Enumeration<PluginEntry> entries() {
        return Collections.enumeration(Lists.transform(Collections.list(this.jarFile.entries()), jarEntry -> {
            try {
                return this.resourceOf((JarEntry)jarEntry);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot convert jar entry " + jarEntry + " to a resource", e);
            }
        }));
    }

    @Override
    public InputStream getInputStream(PluginEntry entry) throws IOException {
        return this.jarFile.getInputStream(this.jarFile.getEntry(entry.getName()));
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    private PluginEntry resourceOf(JarEntry jarEntry) throws IOException {
        return new PluginEntry(jarEntry.getName(), jarEntry.getTime(), Optional.of(jarEntry.getSize()), this.attributesOf(jarEntry));
    }

    private Map<Object, String> attributesOf(JarEntry jarEntry) throws IOException {
        Attributes attributes = jarEntry.getAttributes();
        if (attributes == null) {
            return Collections.emptyMap();
        }
        return Maps.transformEntries(attributes, new Maps.EntryTransformer<Object, Object, String>(){

            @Override
            public String transformEntry(Object key, Object value) {
                return (String)value;
            }
        });
    }

    private static abstract class AbstractAnnotationVisitor
    extends AnnotationVisitor {
        AbstractAnnotationVisitor() {
            super(327680);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            return null;
        }

        @Override
        public AnnotationVisitor visitArray(String arg0) {
            return null;
        }

        @Override
        public void visitEnum(String arg0, String arg1, String arg2) {
        }

        @Override
        public void visitEnd() {
        }
    }

    public static class ClassData
    extends ClassVisitor {
        int access;
        String className;
        String superName;
        String annotationName;
        String annotationValue;
        String[] interfaces;
        Collection<String> exports;

        private ClassData(Collection<String> exports) {
            super(327680);
            this.exports = exports;
        }

        boolean isConcrete() {
            return (this.access & 0x400) == 0 && (this.access & 0x200) == 0;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = Type.getObjectType(name).getClassName();
            this.access = access;
            this.superName = superName;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (!visible) {
                return null;
            }
            Optional<String> found = this.exports.stream().filter(x -> x.equals(desc)).findAny();
            if (found.isPresent()) {
                this.annotationName = desc;
                return new AbstractAnnotationVisitor(){

                    @Override
                    public void visit(String name, Object value) {
                        annotationValue = (String)value;
                    }
                };
            }
            return null;
        }

        @Override
        public void visitSource(String arg0, String arg1) {
        }

        @Override
        public void visitOuterClass(String arg0, String arg1, String arg2) {
        }

        @Override
        public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
            return null;
        }

        @Override
        public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
        }

        @Override
        public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
            return null;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visitAttribute(Attribute arg0) {
        }
    }
}

