/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.Lists;
import com.google.gerrit.common.errors.PermissionDeniedException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.server.git.BanCommitResult;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;

@Singleton
public class BanCommit
extends RetryingRestModifyView<ProjectResource, Input, BanResultInfo> {
    private final com.google.gerrit.server.git.BanCommit banCommit;

    @Inject
    BanCommit(RetryHelper retryHelper, com.google.gerrit.server.git.BanCommit banCommit) {
        super(retryHelper);
        this.banCommit = banCommit;
    }

    @Override
    protected BanResultInfo applyImpl(BatchUpdate.Factory updateFactory, ProjectResource rsrc, Input input) throws RestApiException, UpdateException, IOException {
        BanResultInfo r = new BanResultInfo();
        if (input != null && input.commits != null && !input.commits.isEmpty()) {
            ArrayList<ObjectId> commitsToBan = new ArrayList<ObjectId>(input.commits.size());
            for (String c : input.commits) {
                try {
                    commitsToBan.add(ObjectId.fromString(c));
                }
                catch (IllegalArgumentException e) {
                    throw new UnprocessableEntityException(e.getMessage());
                }
            }
            try {
                BanCommitResult result = this.banCommit.ban(rsrc.getControl(), commitsToBan, input.reason);
                r.newlyBanned = BanCommit.transformCommits(result.getNewlyBannedCommits());
                r.alreadyBanned = BanCommit.transformCommits(result.getAlreadyBannedCommits());
                r.ignored = BanCommit.transformCommits(result.getIgnoredObjectIds());
            }
            catch (PermissionDeniedException e) {
                throw new AuthException(e.getMessage());
            }
        }
        return r;
    }

    private static List<String> transformCommits(List<ObjectId> commits) {
        if (commits == null || commits.isEmpty()) {
            return null;
        }
        return Lists.transform(commits, AnyObjectId::getName);
    }

    public static class BanResultInfo {
        public List<String> newlyBanned;
        public List<String> alreadyBanned;
        public List<String> ignored;
    }

    public static class Input {
        public List<String> commits;
        public String reason;

        public static Input fromCommits(String firstCommit, String ... moreCommits) {
            return Input.fromCommits(Lists.asList(firstCommit, moreCommits));
        }

        public static Input fromCommits(List<String> commits) {
            Input in = new Input();
            in.commits = commits;
            return in;
        }
    }
}

