/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;

public class StarPredicate
extends ChangeIndexPredicate {
    protected final Account.Id accountId;
    protected final String label;

    public StarPredicate(Account.Id accountId, String label) {
        super(ChangeField.STAR, StarredChangesUtil.StarField.create(accountId, label).toString());
        this.accountId = accountId;
        this.label = label;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        return ((ImmutableList)cd.stars().get((Object)this.accountId)).contains(this.label);
    }

    @Override
    public int getCost() {
        return 1;
    }

    @Override
    public String toString() {
        return "star:" + this.label;
    }
}

