/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingIdPredicate
extends ChangeIndexPredicate {
    private static final Logger log = LoggerFactory.getLogger(TrackingIdPredicate.class);

    public TrackingIdPredicate(String trackingId) {
        super(ChangeField.TR, trackingId);
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        try {
            return cd.trackingFooters().containsValue(this.getValue());
        }
        catch (IOException e) {
            log.warn("Cannot extract footers from " + cd.getId(), e);
            return false;
        }
    }

    @Override
    public int getCost() {
        return 1;
    }
}

