/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.gerrit.common.data.RefConfigSection;
import com.google.gerrit.server.project.RefPattern;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public final class MostSpecificComparator
implements Comparator<RefConfigSection> {
    private final String refName;

    public MostSpecificComparator(String refName) {
        this.refName = refName;
    }

    @Override
    public int compare(RefConfigSection a, RefConfigSection b) {
        return this.compare(a.getName(), b.getName());
    }

    @Override
    public int compare(String pattern1, String pattern2) {
        int cmp = this.distance(pattern1) - this.distance(pattern2);
        if (cmp == 0) {
            boolean p1_finite = this.finite(pattern1);
            boolean p2_finite = this.finite(pattern2);
            cmp = p1_finite && !p2_finite ? -1 : (!p1_finite && p2_finite ? 1 : 0);
        }
        if (cmp == 0) {
            cmp = this.transitions(pattern2) - this.transitions(pattern1);
        }
        if (cmp == 0) {
            cmp = pattern2.length() - pattern1.length();
        }
        return cmp;
    }

    private int distance(String pattern) {
        String example;
        if (RefPattern.isRE(pattern)) {
            example = RefPattern.shortestExample(pattern);
        } else if (pattern.endsWith("/*")) {
            example = pattern;
        } else {
            if (pattern.equals(this.refName)) {
                return 0;
            }
            return Math.max(pattern.length(), this.refName.length());
        }
        return StringUtils.getLevenshteinDistance(example, this.refName);
    }

    private boolean finite(String pattern) {
        if (RefPattern.isRE(pattern)) {
            return RefPattern.toRegExp(pattern).toAutomaton().isFinite();
        }
        return !pattern.endsWith("/*");
    }

    private int transitions(String pattern) {
        if (RefPattern.isRE(pattern)) {
            return RefPattern.toRegExp(pattern).toAutomaton().getNumberOfTransitions();
        }
        if (pattern.endsWith("/*")) {
            return pattern.length();
        }
        return pattern.length();
    }
}

