/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.SubmoduleSubscription;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.lib.Config;

public class SubmoduleSectionParser {
    private final Config bbc;
    private final String canonicalWebUrl;
    private final Branch.NameKey superProjectBranch;

    public SubmoduleSectionParser(Config bbc, String canonicalWebUrl, Branch.NameKey superProjectBranch) {
        this.bbc = bbc;
        this.canonicalWebUrl = canonicalWebUrl;
        this.superProjectBranch = superProjectBranch;
    }

    public Set<SubmoduleSubscription> parseAllSections() {
        HashSet<SubmoduleSubscription> parsedSubscriptions = new HashSet<SubmoduleSubscription>();
        for (String id : this.bbc.getSubsections("submodule")) {
            SubmoduleSubscription subscription = this.parse(id);
            if (subscription == null) continue;
            parsedSubscriptions.add(subscription);
        }
        return parsedSubscriptions;
    }

    private SubmoduleSubscription parse(String id) {
        String url = this.bbc.getString("submodule", id, "url");
        String path = this.bbc.getString("submodule", id, "path");
        String branch = this.bbc.getString("submodule", id, "branch");
        try {
            if (url != null && url.length() > 0 && path != null && path.length() > 0 && branch != null && branch.length() > 0) {
                String project;
                if (branch.equals(".")) {
                    branch = this.superProjectBranch.get();
                }
                if (url.startsWith("../")) {
                    project = '/' + this.superProjectBranch.getParentKey().get();
                    String hostPart = url;
                    while (hostPart.startsWith("../")) {
                        int lastSlash = project.lastIndexOf(47);
                        if (lastSlash < 0) {
                            return null;
                        }
                        project = project.substring(0, lastSlash);
                        hostPart = hostPart.substring(3);
                    }
                    project = project + "/" + hostPart;
                    project = project.substring(1);
                } else {
                    String p2;
                    URI targetServerURI = new URI(url);
                    URI thisServerURI = new URI(this.canonicalWebUrl);
                    String thisHost = thisServerURI.getHost();
                    String targetHost = targetServerURI.getHost();
                    if (thisHost == null || targetHost == null || !targetHost.equalsIgnoreCase(thisHost)) {
                        return null;
                    }
                    String p1 = targetServerURI.getPath();
                    if (!p1.startsWith(p2 = thisServerURI.getPath())) {
                        return null;
                    }
                    project = p1.substring(p2.length());
                }
                while (project.startsWith("/")) {
                    project = project.substring(1);
                }
                if (project.endsWith(".git")) {
                    project = project.substring(0, project.length() - ".git".length());
                }
                Project.NameKey projectKey = new Project.NameKey(project);
                return new SubmoduleSubscription(this.superProjectBranch, new Branch.NameKey(projectKey, branch), path);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }
}

