/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.SshScope;
import com.google.gerrit.sshd.SshSession;
import com.google.inject.Inject;
import java.io.IOException;
import org.apache.sshd.server.Environment;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Repository;
import org.kohsuke.args4j.Argument;

public abstract class AbstractGitCommand
extends BaseCommand {
    @Argument(index=0, metaVar="PROJECT.git", required=true, usage="project name")
    protected ProjectControl projectControl;
    @Inject
    private SshScope sshScope;
    @Inject
    private GitRepositoryManager repoManager;
    @Inject
    private SshSession session;
    @Inject
    private SshScope.Context context;
    @Inject
    private IdentifiedUser user;
    @Inject
    private IdentifiedUser.GenericFactory userFactory;
    protected Repository repo;
    protected ProjectState state;
    protected Project.NameKey projectName;
    protected Project project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Environment env) {
        SshScope.Context ctx = this.context.subContext(this.newSession(), this.context.getCommandLine());
        SshScope.Context old = this.sshScope.set(ctx);
        try {
            this.startThread(new BaseCommand.ProjectCommandRunnable(){

                @Override
                public void executeParseCommand() throws Exception {
                    AbstractGitCommand.this.parseCommandLine();
                }

                @Override
                public void run() throws Exception {
                    AbstractGitCommand.this.service();
                }

                @Override
                public Project.NameKey getProjectName() {
                    Project project = AbstractGitCommand.this.projectControl.getProjectState().getProject();
                    return project.getNameKey();
                }
            }, AccessPath.GIT);
        }
        finally {
            this.sshScope.set(old);
        }
    }

    private SshSession newSession() {
        SshSession n = new SshSession(this.session, this.session.getRemoteAddress(), this.userFactory.create(this.session.getRemoteAddress(), this.user.getAccountId()));
        return n;
    }

    private void service() throws IOException, PermissionBackendException, BaseCommand.Failure {
        this.state = this.projectControl.getProjectState();
        this.project = this.state.getProject();
        this.projectName = this.project.getNameKey();
        try {
            this.repo = this.repoManager.openRepository(this.projectName);
        }
        catch (RepositoryNotFoundException e) {
            throw new BaseCommand.Failure(1, "fatal: '" + this.project.getName() + "': not a git archive", e);
        }
        try {
            this.runImpl();
        }
        finally {
            this.repo.close();
        }
    }

    protected abstract void runImpl() throws IOException, PermissionBackendException, BaseCommand.Failure;
}

