/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.group.ListGroups;
import com.google.gerrit.server.ioutil.ColumnFormatter;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gerrit.util.cli.Options;
import com.google.inject.Inject;
import java.util.Optional;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="ls-groups", description="List groups visible to the caller", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
public class ListGroupsCommand
extends SshCommand {
    @Inject
    private GroupCache groupCache;
    @Inject
    @Options
    public ListGroups listGroups;
    @Option(name="--verbose", aliases={"-v"}, usage="verbose output format with tab-separated columns for the group name, UUID, description, owner group name, owner group UUID, and whether the group is visible to all")
    private boolean verboseOutput;

    @Override
    public void run() throws Exception {
        if (this.listGroups.getUser() != null && !this.listGroups.getProjects().isEmpty()) {
            throw this.die("--user and --project options are not compatible.");
        }
        ColumnFormatter formatter = new ColumnFormatter(this.stdout, '\t');
        for (GroupInfo info : this.listGroups.get()) {
            formatter.addColumn(MoreObjects.firstNonNull(info.name, "n/a"));
            if (this.verboseOutput) {
                Optional<InternalGroup> group = info.ownerId != null ? this.groupCache.get(new AccountGroup.UUID(Url.decode(info.ownerId))) : Optional.empty();
                formatter.addColumn(Url.decode(info.id));
                formatter.addColumn(Strings.nullToEmpty(info.description));
                formatter.addColumn(group.map(InternalGroup::getName).orElse("n/a"));
                formatter.addColumn(group.map(g -> g.getGroupUUID().get()).orElse(""));
                formatter.addColumn(Boolean.toString(MoreObjects.firstNonNull(info.options.visibleToAll, Boolean.FALSE)));
            }
            formatter.nextLine();
        }
        formatter.finish();
    }
}

