/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.ConditionalBranches;
import com.google.template.soy.soytree.TagName;
import java.util.ArrayDeque;
import java.util.List;
import javax.annotation.Nullable;

final class HtmlTagEntry {
    private final TagName tagName;
    private final ConditionalBranches branches;
    private static final SoyErrorKind UNSUPPORTED_HTML_TAG_NODE = SoyErrorKind.of("Strict HTML validation only supports matching tags that are raw texts or print commands.");
    private static final SoyErrorKind MISMATCH_DYNAMIC_TAG = SoyErrorKind.of("The print commands need to be identical for dynamic tags.");
    private static final SoyErrorKind UNEXPECTED_CLOSE_TAG = SoyErrorKind.of("Unexpected HTML close tag.");
    private static final SoyErrorKind UNEXPECTED_CLOSE_TAG_WITH_EXPECTATION = SoyErrorKind.of("Unexpected HTML close tag. Expected: ''</{0}>''.");
    private static final SoyErrorKind OPEN_TAG_NOT_CLOSED = SoyErrorKind.of("Expected tag to be closed.");
    private static final SoyErrorKind MISMATCH_TAG = SoyErrorKind.of("Could not find a match for this HTML tag.");

    HtmlTagEntry(TagName tagName) {
        this.tagName = tagName;
        this.branches = null;
    }

    HtmlTagEntry(ConditionalBranches branches) {
        this.tagName = null;
        this.branches = new ConditionalBranches(branches);
    }

    boolean hasTagName() {
        return this.tagName != null;
    }

    @Nullable
    TagName getTagName() {
        return this.tagName;
    }

    @Nullable
    ConditionalBranches getBranches() {
        return this.branches;
    }

    boolean hasEmptyBranches() {
        return this.branches != null && this.branches.isEmpty();
    }

    SourceLocation getSourceLocation() {
        if (this.hasTagName()) {
            return this.tagName.getTagLocation();
        }
        for (ConditionalBranches.ConditionalBranch branch : this.branches.getBranches()) {
            if (branch.deque().isEmpty()) continue;
            return branch.deque().peek().getSourceLocation();
        }
        return SourceLocation.UNKNOWN;
    }

    boolean isDefinitelyOptional() {
        return this.hasTagName() && this.tagName.isDefinitelyOptional();
    }

    public String toString() {
        return this.hasTagName() ? this.tagName.toString() : this.branches.toString();
    }

    static boolean tryMatchOrError(ArrayDeque<HtmlTagEntry> openStack, ArrayDeque<HtmlTagEntry> closeQueue, ErrorReporter errorReporter) {
        while (!openStack.isEmpty() && !closeQueue.isEmpty()) {
            HtmlTagEntry openTag = openStack.peekFirst();
            HtmlTagEntry closeTag = closeQueue.peekFirst();
            if (closeTag.isDefinitelyOptional()) {
                if (closeTag.getTagName().equals(openTag.getTagName())) {
                    openStack.pollFirst();
                    closeQueue.pollFirst();
                    continue;
                }
                if (!openTag.hasTagName()) {
                    if (HtmlTagEntry.tryMatchCommonPrefix(openTag, closeTag, errorReporter)) {
                        openStack.pollFirst();
                        closeQueue.pollFirst();
                        return true;
                    }
                    return false;
                }
            }
            if (closeTag.hasTagName()) {
                while (!openStack.isEmpty()) {
                    openTag = openStack.peekFirst();
                    if (openTag.isDefinitelyOptional()) {
                        openStack.pollFirst();
                        continue;
                    }
                    if (openTag.hasTagName()) break;
                    openTag.getBranches().popOptionalTags();
                    if (!openTag.getBranches().isEmpty()) break;
                    openStack.pollFirst();
                }
            }
            if (HtmlTagEntry.matchOrError(openTag, closeTag, errorReporter)) {
                openStack.pollFirst();
                closeQueue.pollFirst();
                continue;
            }
            return false;
        }
        return true;
    }

    static boolean matchOrError(ArrayDeque<HtmlTagEntry> openStack, ArrayDeque<HtmlTagEntry> closeQueue, ErrorReporter errorReporter) {
        if (!HtmlTagEntry.tryMatchOrError(openStack, closeQueue, errorReporter)) {
            return false;
        }
        HtmlTagEntry openTag = openStack.peekFirst();
        while (openTag != null && (openTag.isDefinitelyOptional() || openTag.hasEmptyBranches())) {
            openTag = openStack.peekFirst();
            openStack.pollFirst();
        }
        if (!openStack.isEmpty()) {
            errorReporter.report(openTag.getSourceLocation(), OPEN_TAG_NOT_CLOSED, new Object[0]);
            return false;
        }
        if (!closeQueue.isEmpty()) {
            errorReporter.report(closeQueue.getFirst().getSourceLocation(), UNEXPECTED_CLOSE_TAG, new Object[0]);
            return false;
        }
        return true;
    }

    static boolean matchOrError(TagName openTag, TagName closeTag, ErrorReporter errorReporter) {
        if (openTag.isStatic() != closeTag.isStatic()) {
            errorReporter.report(closeTag.getTagLocation(), UNSUPPORTED_HTML_TAG_NODE, new Object[0]);
            return false;
        }
        if (!openTag.equals(closeTag)) {
            if (openTag.isStatic()) {
                errorReporter.report(closeTag.getTagLocation(), UNEXPECTED_CLOSE_TAG_WITH_EXPECTATION, openTag.getStaticTagNameAsLowerCase().get());
            } else {
                errorReporter.report(closeTag.getTagLocation(), MISMATCH_DYNAMIC_TAG, new Object[0]);
            }
            return false;
        }
        return true;
    }

    public static boolean matchOrError(@Nullable HtmlTagEntry openTag, @Nullable HtmlTagEntry closeTag, ErrorReporter errorReporter) {
        if (openTag == null && closeTag == null) {
            return true;
        }
        if (openTag == null && closeTag != null) {
            errorReporter.report(closeTag.getSourceLocation(), UNEXPECTED_CLOSE_TAG, new Object[0]);
            return false;
        }
        if (openTag != null && closeTag == null) {
            errorReporter.report(openTag.getSourceLocation(), OPEN_TAG_NOT_CLOSED, new Object[0]);
            return false;
        }
        if (openTag.hasTagName() != closeTag.hasTagName()) {
            return HtmlTagEntry.tryMatchCommonPrefix(openTag, closeTag, errorReporter);
        }
        if (openTag.hasTagName()) {
            return HtmlTagEntry.matchOrError(openTag.getTagName(), closeTag.getTagName(), errorReporter);
        }
        List<ConditionalBranches.ConditionalBranch> openBranches = openTag.getBranches().getBranches();
        List<ConditionalBranches.ConditionalBranch> closeBranches = closeTag.getBranches().getBranches();
        SourceLocation location = closeTag.getSourceLocation();
        if (openBranches.size() != closeBranches.size()) {
            errorReporter.report(location, MISMATCH_TAG, new Object[0]);
            return false;
        }
        for (int i = 0; i < openBranches.size(); ++i) {
            ArrayDeque<HtmlTagEntry> closeQueue;
            ConditionalBranches.ConditionalBranch openBranch = openBranches.get(i);
            ConditionalBranches.ConditionalBranch closeBranch = closeBranches.get(i);
            if (!openBranch.condition().equals(closeBranch.condition())) {
                errorReporter.report(location, MISMATCH_TAG, new Object[0]);
                return false;
            }
            ArrayDeque<HtmlTagEntry> openStack = openBranch.deque();
            if (HtmlTagEntry.matchOrError(openStack, closeQueue = closeBranch.deque(), errorReporter)) continue;
            return false;
        }
        return true;
    }

    static boolean tryMatchCloseTag(ArrayDeque<HtmlTagEntry> openStack, TagName closeTag, ErrorReporter errorReporter) {
        HtmlTagEntry openTag = openStack.peekFirst();
        while (openTag != null && openTag.hasTagName() && !openTag.getTagName().equals(closeTag) && openTag.isDefinitelyOptional()) {
            openStack.pollFirst();
            openTag = openStack.peekFirst();
        }
        if (openTag == null) {
            return false;
        }
        if (openTag.hasTagName()) {
            if (HtmlTagEntry.matchOrError(openTag.getTagName(), closeTag, errorReporter)) {
                openStack.pollFirst();
            }
        } else {
            boolean matchCommonPrefix = HtmlTagEntry.tryMatchCommonPrefix(openStack.peekFirst(), closeTag);
            if (matchCommonPrefix && openStack.peekFirst().hasEmptyBranches()) {
                openStack.pollFirst();
            }
            if (!matchCommonPrefix) {
                return false;
            }
        }
        return true;
    }

    static boolean tryMatchCloseTag(ArrayDeque<HtmlTagEntry> openStack, HtmlTagEntry closeTag, ErrorReporter errorReporter) {
        if (closeTag.hasTagName()) {
            return HtmlTagEntry.tryMatchCloseTag(openStack, closeTag.getTagName(), errorReporter);
        }
        HtmlTagEntry openTag = openStack.peekFirst();
        if (openTag == null) {
            return false;
        }
        if (openTag.hasTagName()) {
            boolean matchCommonPrefix = HtmlTagEntry.tryMatchCommonPrefix(closeTag, openTag.getTagName());
            if (matchCommonPrefix && closeTag.hasEmptyBranches()) {
                return true;
            }
            if (!matchCommonPrefix) {
                return false;
            }
        } else if (HtmlTagEntry.matchOrError(openTag, closeTag, errorReporter)) {
            openStack.pollFirst();
        } else {
            return false;
        }
        return true;
    }

    static boolean tryMatchCommonPrefix(HtmlTagEntry entry, TagName tagName) {
        Preconditions.checkArgument(!entry.hasTagName());
        if (entry.getBranches().hasCommonPrefix(tagName)) {
            entry.getBranches().popAllBranches();
            return true;
        }
        return false;
    }

    private static boolean tryMatchCommonPrefix(HtmlTagEntry openTag, TagName closeTag, ErrorReporter errorReporter) {
        boolean matchCommonPrefix = HtmlTagEntry.tryMatchCommonPrefix(openTag, closeTag);
        if (matchCommonPrefix && !openTag.getBranches().isEmpty()) {
            matchCommonPrefix = false;
            errorReporter.report(openTag.getSourceLocation(), OPEN_TAG_NOT_CLOSED, new Object[0]);
        }
        if (!matchCommonPrefix) {
            errorReporter.report(closeTag.getTagLocation(), UNEXPECTED_CLOSE_TAG, new Object[0]);
        }
        return matchCommonPrefix;
    }

    private static boolean tryMatchCommonPrefix(TagName openTag, HtmlTagEntry closeTag, ErrorReporter errorReporter) {
        boolean matchCommonPrefix = HtmlTagEntry.tryMatchCommonPrefix(closeTag, openTag);
        if (matchCommonPrefix && !closeTag.getBranches().isEmpty()) {
            matchCommonPrefix = false;
            errorReporter.report(closeTag.getSourceLocation(), UNEXPECTED_CLOSE_TAG_WITH_EXPECTATION, openTag.getStaticTagNameAsLowerCase().get());
        }
        if (!matchCommonPrefix) {
            errorReporter.report(openTag.getTagLocation(), OPEN_TAG_NOT_CLOSED, new Object[0]);
        }
        return matchCommonPrefix;
    }

    private static boolean tryMatchCommonPrefix(HtmlTagEntry openTag, HtmlTagEntry closeTag, ErrorReporter errorReporter) {
        Preconditions.checkArgument(openTag.hasTagName() != closeTag.hasTagName());
        return openTag.hasTagName() ? HtmlTagEntry.tryMatchCommonPrefix(openTag.getTagName(), closeTag, errorReporter) : HtmlTagEntry.tryMatchCommonPrefix(openTag, closeTag.getTagName(), errorReporter);
    }
}

