/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.smtp;

import com.google.gerrit.util.ssl.BlindSSLSocketFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;

public class AuthSMTPClient
extends SMTPClient {
    private String authTypes;
    private static final char[] hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public AuthSMTPClient(String charset) {
        super(charset);
    }

    public void enableSSL(boolean verify) {
        this._socketFactory_ = AuthSMTPClient.sslFactory(verify);
    }

    public boolean startTLS(String hostname, int port, boolean verify) throws SocketException, IOException {
        if (this.sendCommand("STARTTLS") != 220) {
            return false;
        }
        this._socket_ = AuthSMTPClient.sslFactory(verify).createSocket(this._socket_, hostname, port, true);
        if (verify) {
            SSLParameters sslParams = new SSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            ((SSLSocket)this._socket_).setSSLParameters(sslParams);
        }
        this._socket_.setSoTimeout(this._timeout_);
        this._input_ = this._socket_.getInputStream();
        this._output_ = this._socket_.getOutputStream();
        this._reader = new BufferedReader(new InputStreamReader(this._input_, StandardCharsets.UTF_8));
        this._writer = new BufferedWriter(new OutputStreamWriter(this._output_, StandardCharsets.UTF_8));
        return true;
    }

    private static SSLSocketFactory sslFactory(boolean verify) {
        if (verify) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        return (SSLSocketFactory)BlindSSLSocketFactory.getDefault();
    }

    @Override
    public boolean login() throws IOException {
        String name = this.getLocalAddress().getHostName();
        if (name == null) {
            return false;
        }
        boolean ok = SMTPReply.isPositiveCompletion(this.sendCommand("EHLO", name));
        this.authTypes = "";
        for (String line : this.getReplyStrings()) {
            if (line == null || !line.startsWith("250 AUTH ") && !line.startsWith("250-AUTH ")) continue;
            this.authTypes = line;
            break;
        }
        return ok;
    }

    public boolean auth(String smtpUser, String smtpPass) throws IOException {
        List<String> types = Arrays.asList(this.authTypes.split(" "));
        if ("".equals(this.authTypes)) {
            return true;
        }
        if (smtpPass == null) {
            smtpPass = "";
        }
        if (types.contains("CRAM-SHA1")) {
            return this.authCram(smtpUser, smtpPass, "SHA1");
        }
        if (types.contains("CRAM-MD5")) {
            return this.authCram(smtpUser, smtpPass, "MD5");
        }
        if (types.contains("LOGIN")) {
            return this.authLogin(smtpUser, smtpPass);
        }
        if (types.contains("PLAIN")) {
            return this.authPlain(smtpUser, smtpPass);
        }
        throw new IOException("Unsupported AUTH: " + this.authTypes);
    }

    private boolean authCram(String smtpUser, String smtpPass, String alg) throws UnsupportedEncodingException, IOException {
        String sec;
        String macName = "Hmac" + alg;
        if (this.sendCommand("AUTH", "CRAM-" + alg) != 334) {
            return false;
        }
        String enc = this.getReplyStrings()[0].split(" ", 2)[1];
        byte[] nonce = Base64.decodeBase64(enc.getBytes(StandardCharsets.UTF_8));
        try {
            Mac mac = Mac.getInstance(macName);
            mac.init(new SecretKeySpec(smtpPass.getBytes(StandardCharsets.UTF_8), macName));
            sec = this.toHex(mac.doFinal(nonce));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IOException("Cannot use CRAM-" + alg, e);
        }
        String token = smtpUser + ' ' + sec;
        String cmd = AuthSMTPClient.encodeBase64(token.getBytes(StandardCharsets.UTF_8));
        return SMTPReply.isPositiveCompletion(this.sendCommand(cmd));
    }

    private boolean authLogin(String smtpUser, String smtpPass) throws UnsupportedEncodingException, IOException {
        if (this.sendCommand("AUTH", "LOGIN") != 334) {
            return false;
        }
        String cmd = AuthSMTPClient.encodeBase64(smtpUser.getBytes(StandardCharsets.UTF_8));
        if (this.sendCommand(cmd) != 334) {
            return false;
        }
        cmd = AuthSMTPClient.encodeBase64(smtpPass.getBytes(StandardCharsets.UTF_8));
        return SMTPReply.isPositiveCompletion(this.sendCommand(cmd));
    }

    private String toHex(byte[] b) {
        StringBuilder sec = new StringBuilder();
        for (byte c : b) {
            int u = c >> 4 & 0xF;
            int l = c & 0xF;
            sec.append(hexchar[u]);
            sec.append(hexchar[l]);
        }
        return sec.toString();
    }

    private boolean authPlain(String smtpUser, String smtpPass) throws UnsupportedEncodingException, IOException {
        String token = '\u0000' + smtpUser + '\u0000' + smtpPass;
        String cmd = "PLAIN " + AuthSMTPClient.encodeBase64(token.getBytes(StandardCharsets.UTF_8));
        return SMTPReply.isPositiveCompletion(this.sendCommand("AUTH", cmd));
    }

    private static String encodeBase64(byte[] data) {
        return new String(Base64.encodeBase64(data), StandardCharsets.UTF_8);
    }
}

