/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.util.Printer;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGroup;

public class InstructionGraphNode
extends BasicValue {
    private static final Range<Integer> ILOAD_INSN_RANGE = Range.closedOpen(21, 46);
    private static final Range<Integer> ISTORE_INSN_RANGE = Range.closedOpen(54, 79);
    private final BasicValue resultValue;
    private final List<InstructionGraphNode> predecessors = new ArrayList<InstructionGraphNode>();
    private AbstractInsnNode instruction;
    private InstructionGroup group;
    private boolean isActionRoot;

    public InstructionGraphNode(AbstractInsnNode instruction, BasicValue resultValue) {
        super(null);
        this.instruction = instruction;
        this.resultValue = resultValue;
        this.isActionRoot = AsmUtils.isActionRoot(instruction);
    }

    @Override
    public int getSize() {
        return this.resultValue.getSize();
    }

    public AbstractInsnNode getInstruction() {
        return this.instruction;
    }

    public void setInstruction(AbstractInsnNode instruction) {
        this.instruction = instruction;
    }

    public BasicValue getResultValue() {
        return this.resultValue;
    }

    public List<InstructionGraphNode> getPredecessors() {
        return this.predecessors;
    }

    public InstructionGroup getGroup() {
        return this.group;
    }

    public void setGroup(@Nullable InstructionGroup newGroup) {
        if (newGroup == this.group) {
            return;
        }
        if (this.group != null) {
            this.group.getNodes().remove(this);
        }
        this.group = newGroup;
        if (this.group != null) {
            this.group.getNodes().add(this);
        }
    }

    public boolean isActionRoot() {
        return this.isActionRoot;
    }

    public void setIsActionRoot() {
        this.isActionRoot = true;
    }

    public boolean isVarInitRoot() {
        return AsmUtils.isVarRoot(this.instruction);
    }

    public boolean isCallOnContextAware() {
        return AsmUtils.isCallOnContextAware(this.instruction);
    }

    public boolean isXLoad() {
        return ILOAD_INSN_RANGE.contains(this.instruction.getOpcode());
    }

    public boolean isXStore() {
        return ISTORE_INSN_RANGE.contains(this.instruction.getOpcode());
    }

    public void addPredecessors(@Nonnull Collection<BasicValue> preds) {
        Preconditions.checkNotNull(preds, "preds");
        for (BasicValue pred : preds) {
            if (!(pred instanceof InstructionGraphNode)) continue;
            this.addPredecessor((InstructionGraphNode)pred);
        }
    }

    public void addPredecessor(InstructionGraphNode node) {
        if (!this.predecessors.contains(node)) {
            this.predecessors.add(node);
        }
    }

    @Override
    public boolean equals(@Nullable Object value) {
        return value == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        return this.instruction.getOpcode() != -1 ? Printer.OPCODES[this.instruction.getOpcode()] : super.toString();
    }
}

