/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.parsers;

import com.github.parboiled1.grappa.helpers.ValueBuilder;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import javax.annotation.Nonnull;
import org.parboiled.BaseParser;
import org.parboiled.support.Var;

public abstract class EventBusParser<V>
extends BaseParser<V> {
    protected final EventBus bus = new EventBus();

    public final boolean register(@Nonnull Object listener) {
        this.bus.register(Preconditions.checkNotNull(listener));
        return true;
    }

    public final boolean unregister(@Nonnull Object listener) {
        this.bus.unregister(Preconditions.checkNotNull(listener));
        return true;
    }

    public final <T> boolean post(@Nonnull ValueBuilder<T> builder) {
        Preconditions.checkNotNull(builder);
        T event = builder.build();
        this.bus.post(event);
        return true;
    }

    public final <T> boolean post(@Nonnull Var<T> var) {
        Preconditions.checkNotNull(var);
        Object value = Preconditions.checkNotNull(var.get());
        this.bus.post(value);
        return true;
    }

    public final boolean postRaw(@Nonnull Object object) {
        Preconditions.checkNotNull(object);
        this.bus.post(object);
        return true;
    }
}

