/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.api.access;

import com.google.common.base.Preconditions;
import com.google.gerrit.extensions.api.access.GlobalOrPluginPermission;
import java.util.Objects;

public class PluginPermission
implements GlobalOrPluginPermission {
    private final String pluginName;
    private final String capability;
    private final boolean fallBackToAdmin;

    public PluginPermission(String pluginName, String capability) {
        this(pluginName, capability, true);
    }

    public PluginPermission(String pluginName, String capability, boolean fallBackToAdmin) {
        this.pluginName = Preconditions.checkNotNull(pluginName, "pluginName");
        this.capability = Preconditions.checkNotNull(capability, "capability");
        this.fallBackToAdmin = fallBackToAdmin;
    }

    public String pluginName() {
        return this.pluginName;
    }

    public String capability() {
        return this.capability;
    }

    public boolean fallBackToAdmin() {
        return this.fallBackToAdmin;
    }

    @Override
    public String permissionName() {
        return this.pluginName + '-' + this.capability;
    }

    @Override
    public String describeForException() {
        return this.capability + " for plugin " + this.pluginName;
    }

    public int hashCode() {
        return Objects.hash(this.pluginName, this.capability);
    }

    public boolean equals(Object other) {
        if (other instanceof PluginPermission) {
            PluginPermission b = (PluginPermission)other;
            return this.pluginName.equals(b.pluginName) && this.capability.equals(b.capability);
        }
        return false;
    }

    public String toString() {
        return "PluginPermission[plugin=" + this.pluginName + ", capability=" + this.capability + ']';
    }
}

