/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.httpd.restapi.RestApiServlet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.servlet.ServletModule;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class RunAsFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RunAsFilter.class);
    private static final String RUN_AS = "X-Gerrit-RunAs";
    private final boolean enabled;
    private final DynamicItem<WebSession> session;
    private final PermissionBackend permissionBackend;
    private final AccountResolver accountResolver;

    @Inject
    RunAsFilter(AuthConfig config, DynamicItem<WebSession> session, PermissionBackend permissionBackend, AccountResolver accountResolver) {
        this.enabled = config.isRunAsEnabled();
        this.session = session;
        this.permissionBackend = permissionBackend;
        this.accountResolver = accountResolver;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String runas = req.getHeader(RUN_AS);
        if (runas != null) {
            Account target;
            if (!this.enabled) {
                RestApiServlet.replyError(req, res, 403, "X-Gerrit-RunAs disabled by auth.enableRunAs = false", null);
                return;
            }
            CurrentUser self = this.session.get().getUser();
            try {
                if (!self.isIdentifiedUser()) {
                    throw new AuthException("denied");
                }
                this.permissionBackend.user(self).check(GlobalPermission.RUN_AS);
            }
            catch (AuthException e) {
                RestApiServlet.replyError(req, res, 403, "not permitted to use X-Gerrit-RunAs", null);
                return;
            }
            catch (PermissionBackendException e) {
                log.warn("cannot check runAs", e);
                RestApiServlet.replyError(req, res, 500, "X-Gerrit-RunAs unavailable", null);
                return;
            }
            try {
                target = this.accountResolver.find(runas);
            }
            catch (OrmException | IOException | ConfigInvalidException e) {
                log.warn("cannot resolve account for X-Gerrit-RunAs", e);
                RestApiServlet.replyError(req, res, 500, "cannot resolve X-Gerrit-RunAs", e);
                return;
            }
            if (target == null) {
                RestApiServlet.replyError(req, res, 403, "no account matches X-Gerrit-RunAs", null);
                return;
            }
            this.session.get().setUserAccountId(target.getId());
        }
        chain.doFilter(req, res);
    }

    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void destroy() {
    }

    static class Module
    extends ServletModule {
        Module() {
        }

        @Override
        protected void configureServlets() {
            this.filter("/*", new String[0]).through(RunAsFilter.class);
        }
    }
}

