/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.AuthConfig;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class XsrfCookieFilter
implements Filter {
    private final Provider<CurrentUser> user;
    private final DynamicItem<WebSession> session;
    private final AuthConfig authConfig;

    @Inject
    XsrfCookieFilter(Provider<CurrentUser> user, DynamicItem<WebSession> session, AuthConfig authConfig) {
        this.user = user;
        this.session = session;
        this.authConfig = authConfig;
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse rsp, FilterChain chain) throws IOException, ServletException {
        WebSession s = this.user.get().isIdentifiedUser() ? this.session.get() : null;
        this.setXsrfTokenCookie((HttpServletRequest)req, (HttpServletResponse)rsp, s);
        chain.doFilter(req, rsp);
    }

    private void setXsrfTokenCookie(HttpServletRequest req, HttpServletResponse rsp, WebSession session) {
        String v = session != null ? session.getXGerritAuth() : null;
        Cookie c = new Cookie("XSRF_TOKEN", Strings.nullToEmpty(v));
        c.setPath("/");
        c.setSecure(this.authConfig.getCookieSecure() && this.isSecure(req));
        c.setMaxAge(v != null ? -1 : 0);
        rsp.addCookie(c);
    }

    private boolean isSecure(HttpServletRequest req) {
        return req.isSecure() || "https".equals(req.getScheme());
    }

    @Override
    public void init(FilterConfig config) {
    }

    @Override
    public void destroy() {
    }
}

