/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.index;

import com.google.common.collect.ImmutableSortedMap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.index.Index;
import com.google.gerrit.index.IndexCollection;
import com.google.gerrit.index.Schema;
import com.google.gerrit.index.SchemaDefinitions;
import com.google.gerrit.index.SiteIndexer;

public abstract class IndexDefinition<K, V, I extends Index<K, V>> {
    private final SchemaDefinitions<V> schemaDefs;
    private final IndexCollection<K, V, I> indexCollection;
    private final IndexFactory<K, V, I> indexFactory;
    private final SiteIndexer<K, V, I> siteIndexer;

    protected IndexDefinition(SchemaDefinitions<V> schemaDefs, IndexCollection<K, V, I> indexCollection, IndexFactory<K, V, I> indexFactory, @Nullable SiteIndexer<K, V, I> siteIndexer) {
        this.schemaDefs = schemaDefs;
        this.indexCollection = indexCollection;
        this.indexFactory = indexFactory;
        this.siteIndexer = siteIndexer;
    }

    public final String getName() {
        return this.schemaDefs.getName();
    }

    public final ImmutableSortedMap<Integer, Schema<V>> getSchemas() {
        return this.schemaDefs.getSchemas();
    }

    public final Schema<V> getLatest() {
        return this.schemaDefs.getLatest();
    }

    public final IndexCollection<K, V, I> getIndexCollection() {
        return this.indexCollection;
    }

    public final IndexFactory<K, V, I> getIndexFactory() {
        return this.indexFactory;
    }

    @Nullable
    public final SiteIndexer<K, V, I> getSiteIndexer() {
        return this.siteIndexer;
    }

    public static interface IndexFactory<K, V, I extends Index<K, V>> {
        public I create(Schema<V> var1);
    }
}

