/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics;

abstract class TimerContext
implements AutoCloseable {
    private final long startNanos = System.nanoTime();
    private boolean stopped;

    TimerContext() {
    }

    public abstract void record(long var1);

    public long getStartTime() {
        return this.startNanos;
    }

    public long stop() {
        if (!this.stopped) {
            this.stopped = true;
            long elapsed = System.nanoTime() - this.startNanos;
            this.record(elapsed);
            return elapsed;
        }
        throw new IllegalStateException("Already stopped");
    }

    @Override
    public void close() {
        if (!this.stopped) {
            this.stop();
        }
    }
}

