/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.pgm.init.api;

import com.google.gerrit.pgm.init.api.InitFlags;
import com.google.gerrit.server.GerritPersonIdentProvider;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.VersionedMetaData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FS;

public abstract class VersionedMetaDataOnInit
extends VersionedMetaData {
    protected final String project;
    private final InitFlags flags;
    private final SitePaths site;
    private final String ref;

    protected VersionedMetaDataOnInit(InitFlags flags, SitePaths site, String project, String ref) {
        this.flags = flags;
        this.site = site;
        this.project = project;
        this.ref = ref;
    }

    @Override
    protected String getRefName() {
        return this.ref;
    }

    public VersionedMetaDataOnInit load() throws IOException, ConfigInvalidException {
        File path = this.getPath();
        if (path != null) {
            try (FileRepository repo = new FileRepository(path);){
                this.load(repo);
            }
        }
        return this;
    }

    public void save(String message) throws IOException, ConfigInvalidException {
        this.save(new GerritPersonIdentProvider(this.flags.cfg).get(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(PersonIdent ident, String msg) throws IOException, ConfigInvalidException {
        File path = this.getPath();
        if (path == null) {
            throw new IOException(this.project + " does not exist.");
        }
        try (FileRepository repo = new FileRepository(path);
             ObjectInserter i = repo.newObjectInserter();
             ObjectReader r = repo.newObjectReader();
             RevWalk rw = new RevWalk(r);){
            this.inserter = i;
            this.reader = r;
            RevTree srcTree = this.revision != null ? rw.parseTree(this.revision) : null;
            this.newTree = this.readTree(srcTree);
            CommitBuilder commit = new CommitBuilder();
            commit.setAuthor(ident);
            commit.setCommitter(ident);
            commit.setMessage(msg);
            this.onSave(commit);
            ObjectId res = this.newTree.writeTree(this.inserter);
            if (res.equals(srcTree)) {
                return;
            }
            commit.setTreeId(res);
            if (this.revision != null) {
                commit.addParentId(this.revision);
            }
            ObjectId newRevision = this.inserter.insert(commit);
            this.updateRef(repo, ident, newRevision, "commit: " + msg);
            this.revision = rw.parseCommit(newRevision);
        }
        finally {
            this.inserter = null;
            this.reader = null;
        }
    }

    private void updateRef(Repository repo, PersonIdent ident, ObjectId newRevision, String refLogMsg) throws IOException {
        RefUpdate ru = repo.updateRef(this.getRefName());
        ru.setRefLogIdent(ident);
        ru.setNewObjectId(newRevision);
        ru.setExpectedOldObjectId(this.revision);
        ru.setRefLogMessage(refLogMsg, false);
        RefUpdate.Result r = ru.update();
        switch (r) {
            case FAST_FORWARD: 
            case NEW: 
            case NO_CHANGE: {
                break;
            }
            default: {
                throw new IOException("Failed to update " + this.getRefName() + " of " + this.project + ": " + r.name());
            }
        }
    }

    private File getPath() {
        Path basePath = this.site.resolve(this.flags.cfg.getString("gerrit", null, "basePath"));
        if (basePath == null) {
            throw new IllegalStateException("gerrit.basePath must be configured");
        }
        return RepositoryCache.FileKey.resolve(basePath.resolve(this.project).toFile(), FS.DETECTED);
    }
}

