/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.extensions.client.ChangeKind;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.ChangeKindCache;
import com.google.gerrit.server.git.LabelNormalizer;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class ApprovalCopier {
    private final ProjectCache projectCache;
    private final ChangeKindCache changeKindCache;
    private final LabelNormalizer labelNormalizer;
    private final ChangeData.Factory changeDataFactory;
    private final PatchSetUtil psUtil;

    @Inject
    ApprovalCopier(ProjectCache projectCache, ChangeKindCache changeKindCache, LabelNormalizer labelNormalizer, ChangeData.Factory changeDataFactory, PatchSetUtil psUtil) {
        this.projectCache = projectCache;
        this.changeKindCache = changeKindCache;
        this.labelNormalizer = labelNormalizer;
        this.changeDataFactory = changeDataFactory;
        this.psUtil = psUtil;
    }

    public void copyInReviewDb(ReviewDb db, ChangeNotes notes, CurrentUser user, PatchSet ps, @Nullable RevWalk rw, @Nullable Config repoConfig) throws OrmException {
        this.copyInReviewDb(db, notes, user, ps, rw, repoConfig, Collections.emptyList());
    }

    public void copyInReviewDb(ReviewDb db, ChangeNotes notes, CurrentUser user, PatchSet ps, @Nullable RevWalk rw, @Nullable Config repoConfig, Iterable<PatchSetApproval> dontCopy) throws OrmException {
        if (NoteDbChangeState.PrimaryStorage.of(notes.getChange()) == NoteDbChangeState.PrimaryStorage.REVIEW_DB) {
            db.patchSetApprovals().insert(this.getForPatchSet(db, notes, user, ps, rw, repoConfig, dontCopy));
        }
    }

    Iterable<PatchSetApproval> getForPatchSet(ReviewDb db, ChangeNotes notes, CurrentUser user, PatchSet.Id psId, @Nullable RevWalk rw, @Nullable Config repoConfig) throws OrmException {
        return this.getForPatchSet(db, notes, user, psId, rw, repoConfig, Collections.emptyList());
    }

    Iterable<PatchSetApproval> getForPatchSet(ReviewDb db, ChangeNotes notes, CurrentUser user, PatchSet.Id psId, @Nullable RevWalk rw, @Nullable Config repoConfig, Iterable<PatchSetApproval> dontCopy) throws OrmException {
        PatchSet ps = this.psUtil.get(db, notes, psId);
        if (ps == null) {
            return Collections.emptyList();
        }
        return this.getForPatchSet(db, notes, user, ps, rw, repoConfig, dontCopy);
    }

    private Iterable<PatchSetApproval> getForPatchSet(ReviewDb db, ChangeNotes notes, CurrentUser user, PatchSet ps, @Nullable RevWalk rw, @Nullable Config repoConfig, Iterable<PatchSetApproval> dontCopy) throws OrmException {
        Preconditions.checkNotNull(ps, "ps should not be null");
        ChangeData cd = this.changeDataFactory.create(db, notes);
        try {
            ProjectState project = this.projectCache.checkedGet(cd.change().getDest().getParentKey());
            ListMultimap<PatchSet.Id, PatchSetApproval> all = cd.approvals();
            Preconditions.checkNotNull(all, "all should not be null");
            HashBasedTable<String, Account.Id, PatchSetApproval> wontCopy = HashBasedTable.create();
            for (PatchSetApproval patchSetApproval : dontCopy) {
                wontCopy.put(patchSetApproval.getLabel(), patchSetApproval.getAccountId(), patchSetApproval);
            }
            HashBasedTable<String, Account.Id, PatchSetApproval> byUser = HashBasedTable.create();
            for (PatchSetApproval psa : all.get((Object)ps.getId())) {
                if (wontCopy.contains(psa.getLabel(), psa.getAccountId())) continue;
                byUser.put(psa.getLabel(), psa.getAccountId(), psa);
            }
            TreeMap<Integer, PatchSet> treeMap = ApprovalCopier.getPatchSets(cd);
            Collection allPrior = treeMap.descendingMap().tailMap(ps.getId().get(), false).values();
            for (PatchSet priorPs : allPrior) {
                Collection priorApprovals = all.get((Object)priorPs.getId());
                if (priorApprovals.isEmpty()) continue;
                ChangeKind kind = this.changeKindCache.getChangeKind(project.getNameKey(), rw, repoConfig, ObjectId.fromString(priorPs.getRevision().get()), ObjectId.fromString(ps.getRevision().get()));
                for (PatchSetApproval psa : priorApprovals) {
                    if (wontCopy.contains(psa.getLabel(), psa.getAccountId()) || byUser.contains(psa.getLabel(), psa.getAccountId())) continue;
                    if (!ApprovalCopier.canCopy(project, psa, ps.getId(), kind)) {
                        wontCopy.put(psa.getLabel(), psa.getAccountId(), psa);
                        continue;
                    }
                    byUser.put(psa.getLabel(), psa.getAccountId(), ApprovalCopier.copy(psa, ps.getId()));
                }
            }
            return this.labelNormalizer.normalize(notes, user, byUser.values()).getNormalized();
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    private static TreeMap<Integer, PatchSet> getPatchSets(ChangeData cd) throws OrmException {
        Collection<PatchSet> patchSets = cd.patchSets();
        TreeMap<Integer, PatchSet> result = new TreeMap<Integer, PatchSet>();
        for (PatchSet ps : patchSets) {
            result.put(ps.getId().get(), ps);
        }
        return result;
    }

    private static boolean canCopy(ProjectState project, PatchSetApproval psa, PatchSet.Id psId, ChangeKind kind) {
        int n = psa.getKey().getParentKey().get();
        Preconditions.checkArgument(n != psId.get());
        LabelType type = project.getLabelTypes().byLabel(psa.getLabelId());
        if (type == null) {
            return false;
        }
        if (type.isCopyMinScore() && type.isMaxNegative(psa) || type.isCopyMaxScore() && type.isMaxPositive(psa)) {
            return true;
        }
        switch (kind) {
            case MERGE_FIRST_PARENT_UPDATE: {
                return type.isCopyAllScoresOnMergeFirstParentUpdate();
            }
            case NO_CODE_CHANGE: {
                return type.isCopyAllScoresIfNoCodeChange();
            }
            case TRIVIAL_REBASE: {
                return type.isCopyAllScoresOnTrivialRebase();
            }
            case NO_CHANGE: {
                return type.isCopyAllScoresIfNoChange() || type.isCopyAllScoresOnTrivialRebase() || type.isCopyAllScoresOnMergeFirstParentUpdate() || type.isCopyAllScoresIfNoCodeChange();
            }
        }
        return false;
    }

    private static PatchSetApproval copy(PatchSetApproval src, PatchSet.Id psId) {
        if (src.getKey().getParentKey().equals(psId)) {
            return src;
        }
        return new PatchSetApproval(psId, src);
    }
}

