/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.account.externalids.ExternalId;
import java.util.function.Consumer;

public abstract class CurrentUser {
    private AccessPath accessPath = AccessPath.UNKNOWN;
    private PropertyKey<ExternalId.Key> lastLoginExternalIdPropertyKey = PropertyKey.create();

    public final AccessPath getAccessPath() {
        return this.accessPath;
    }

    public void setAccessPath(AccessPath path) {
        this.accessPath = path;
    }

    public CurrentUser getRealUser() {
        return this;
    }

    public boolean isImpersonating() {
        return false;
    }

    public void updateRealAccountId(Consumer<Account.Id> setter) {
        if (this.getRealUser().isIdentifiedUser()) {
            setter.accept(this.getRealUser().getAccountId());
        }
    }

    public abstract GroupMembership getEffectiveGroups();

    public String getUserName() {
        return null;
    }

    public boolean isIdentifiedUser() {
        return false;
    }

    public IdentifiedUser asIdentifiedUser() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is not an IdentifiedUser");
    }

    public Account.Id getAccountId() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is not an IdentifiedUser");
    }

    public boolean isInternalUser() {
        return false;
    }

    @Nullable
    public <T> T get(PropertyKey<T> key) {
        return null;
    }

    public <T> void put(PropertyKey<T> key, @Nullable T value) {
    }

    public void setLastLoginExternalIdKey(ExternalId.Key externalIdKey) {
        this.put(this.lastLoginExternalIdPropertyKey, externalIdKey);
    }

    public ExternalId.Key getLastLoginExternalIdKey() {
        return this.get(this.lastLoginExternalIdPropertyKey);
    }

    public boolean hasSameAccountId(CurrentUser other) {
        return false;
    }

    public static final class PropertyKey<T> {
        public static <T> PropertyKey<T> create() {
            return new PropertyKey<T>();
        }

        private PropertyKey() {
        }
    }
}

