/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.extensions.client.MenuItem;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GeneralPreferencesLoader {
    private static final Logger log = LoggerFactory.getLogger(GeneralPreferencesLoader.class);
    private final GitRepositoryManager gitMgr;
    private final AllUsersName allUsersName;

    @Inject
    public GeneralPreferencesLoader(GitRepositoryManager gitMgr, AllUsersName allUsersName) {
        this.gitMgr = gitMgr;
        this.allUsersName = allUsersName;
    }

    public GeneralPreferencesInfo load(Account.Id id) throws IOException, ConfigInvalidException, RepositoryNotFoundException {
        return this.read(id, null);
    }

    public GeneralPreferencesInfo merge(Account.Id id, GeneralPreferencesInfo in) throws IOException, ConfigInvalidException, RepositoryNotFoundException {
        return this.read(id, in);
    }

    private GeneralPreferencesInfo read(Account.Id id, GeneralPreferencesInfo in) throws IOException, ConfigInvalidException, RepositoryNotFoundException {
        try (Repository allUsers = this.gitMgr.openRepository(this.allUsersName);){
            VersionedAccountPreferences dp = VersionedAccountPreferences.forDefault();
            dp.load(allUsers);
            VersionedAccountPreferences p = VersionedAccountPreferences.forUser(id);
            p.load(allUsers);
            GeneralPreferencesInfo r = ConfigUtil.loadSection(p.getConfig(), "general", null, new GeneralPreferencesInfo(), this.readDefaultsFromGit(dp.getConfig(), in), in);
            this.loadChangeTableColumns(r, p, dp);
            GeneralPreferencesInfo generalPreferencesInfo = this.loadMyMenusAndUrlAliases(r, p, dp);
            return generalPreferencesInfo;
        }
    }

    public GeneralPreferencesInfo readDefaultsFromGit(Repository git, GeneralPreferencesInfo in) throws ConfigInvalidException, IOException {
        VersionedAccountPreferences dp = VersionedAccountPreferences.forDefault();
        dp.load(git);
        return this.readDefaultsFromGit(dp.getConfig(), in);
    }

    private GeneralPreferencesInfo readDefaultsFromGit(Config config, GeneralPreferencesInfo in) throws ConfigInvalidException {
        GeneralPreferencesInfo allUserPrefs = new GeneralPreferencesInfo();
        ConfigUtil.loadSection(config, "general", null, allUserPrefs, GeneralPreferencesInfo.defaults(), in);
        return this.updateDefaults(allUserPrefs);
    }

    private GeneralPreferencesInfo updateDefaults(GeneralPreferencesInfo input) {
        GeneralPreferencesInfo result = GeneralPreferencesInfo.defaults();
        try {
            for (Field field : input.getClass().getDeclaredFields()) {
                Object newVal;
                if (ConfigUtil.skipField(field) || (newVal = field.get(input)) == null) continue;
                field.set(result, newVal);
            }
        }
        catch (IllegalAccessException e) {
            log.error("Cannot get default general preferences from " + this.allUsersName.get(), e);
            return GeneralPreferencesInfo.defaults();
        }
        return result;
    }

    public GeneralPreferencesInfo loadMyMenusAndUrlAliases(GeneralPreferencesInfo r, VersionedAccountPreferences v, VersionedAccountPreferences d) {
        r.my = GeneralPreferencesLoader.my(v);
        if (r.my.isEmpty() && !v.isDefaults()) {
            r.my = GeneralPreferencesLoader.my(d);
        }
        if (r.my.isEmpty()) {
            r.my.add(new MenuItem("Changes", "#/dashboard/self", null));
            r.my.add(new MenuItem("Draft Comments", "#/q/has:draft", null));
            r.my.add(new MenuItem("Edits", "#/q/has:edit", null));
            r.my.add(new MenuItem("Watched Changes", "#/q/is:watched+is:open", null));
            r.my.add(new MenuItem("Starred Changes", "#/q/is:starred", null));
            r.my.add(new MenuItem("Groups", "#/groups/self", null));
        }
        r.urlAliases = GeneralPreferencesLoader.urlAliases(v);
        if (r.urlAliases == null && !v.isDefaults()) {
            r.urlAliases = GeneralPreferencesLoader.urlAliases(d);
        }
        return r;
    }

    private static List<MenuItem> my(VersionedAccountPreferences v) {
        ArrayList<MenuItem> my = new ArrayList<MenuItem>();
        Config cfg = v.getConfig();
        Iterator<String> iterator = cfg.getSubsections("my").iterator();
        while (iterator.hasNext()) {
            String subsection;
            String url = GeneralPreferencesLoader.my(cfg, subsection = iterator.next(), "url", "#/");
            String target = GeneralPreferencesLoader.my(cfg, subsection, "target", url.startsWith("#") ? null : "_blank");
            my.add(new MenuItem(subsection, url, target, GeneralPreferencesLoader.my(cfg, subsection, "id", null)));
        }
        return my;
    }

    private static String my(Config cfg, String subsection, String key, String defaultValue) {
        String val = cfg.getString("my", subsection, key);
        return !Strings.isNullOrEmpty(val) ? val : defaultValue;
    }

    public GeneralPreferencesInfo loadChangeTableColumns(GeneralPreferencesInfo r, VersionedAccountPreferences v, VersionedAccountPreferences d) {
        r.changeTable = GeneralPreferencesLoader.changeTable(v);
        if (r.changeTable.isEmpty() && !v.isDefaults()) {
            r.changeTable = GeneralPreferencesLoader.changeTable(d);
        }
        return r;
    }

    private static List<String> changeTable(VersionedAccountPreferences v) {
        return Lists.newArrayList(v.getConfig().getStringList("changeTable", null, "column"));
    }

    private static Map<String, String> urlAliases(VersionedAccountPreferences v) {
        HashMap<String, String> urlAliases = new HashMap<String, String>();
        Config cfg = v.getConfig();
        for (String subsection : cfg.getSubsections("urlAlias")) {
            urlAliases.put(cfg.getString("urlAlias", subsection, "match"), cfg.getString("urlAlias", subsection, "token"));
        }
        return !urlAliases.isEmpty() ? urlAliases : null;
    }
}

