/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth;

import com.google.common.base.Strings;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.auth.AuthBackend;
import com.google.gerrit.server.auth.AuthException;
import com.google.gerrit.server.auth.AuthRequest;
import com.google.gerrit.server.auth.AuthUser;
import com.google.gerrit.server.auth.InvalidCredentialsException;
import com.google.gerrit.server.auth.MissingCredentialsException;
import com.google.gerrit.server.auth.UnknownUserException;
import com.google.gerrit.server.auth.UserNotAllowedException;
import com.google.gerrit.server.config.AuthConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Locale;

@Singleton
public class InternalAuthBackend
implements AuthBackend {
    private final AccountCache accountCache;
    private final AuthConfig authConfig;

    @Inject
    InternalAuthBackend(AccountCache accountCache, AuthConfig authConfig) {
        this.accountCache = accountCache;
        this.authConfig = authConfig;
    }

    @Override
    public String getDomain() {
        return "gerrit";
    }

    @Override
    public AuthUser authenticate(AuthRequest req) throws MissingCredentialsException, InvalidCredentialsException, UnknownUserException, UserNotAllowedException, AuthException {
        if (Strings.isNullOrEmpty(req.getUsername()) || Strings.isNullOrEmpty(req.getPassword())) {
            throw new MissingCredentialsException();
        }
        String username = this.authConfig.isUserNameToLowerCase() ? req.getUsername().toLowerCase(Locale.US) : req.getUsername();
        AccountState who = this.accountCache.getByUsername(username);
        if (who == null) {
            throw new UnknownUserException();
        }
        if (!who.getAccount().isActive()) {
            throw new UserNotAllowedException("Authentication failed for " + username + ": account inactive or not provisioned in Gerrit");
        }
        if (!who.checkPassword(req.getPassword(), username)) {
            throw new InvalidCredentialsException();
        }
        return new AuthUser(AuthUser.UUID.create(username), username);
    }
}

