/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.EditInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.change.FixResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.gerrit.server.edit.ChangeEditJson;
import com.google.gerrit.server.edit.ChangeEditModifier;
import com.google.gerrit.server.edit.tree.TreeModification;
import com.google.gerrit.server.fixes.FixReplacementInterpreter;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class ApplyFix
implements RestModifyView<FixResource, Void> {
    private final GitRepositoryManager gitRepositoryManager;
    private final FixReplacementInterpreter fixReplacementInterpreter;
    private final ChangeEditModifier changeEditModifier;
    private final ChangeEditJson changeEditJson;
    private final ProjectCache projectCache;

    @Inject
    public ApplyFix(GitRepositoryManager gitRepositoryManager, FixReplacementInterpreter fixReplacementInterpreter, ChangeEditModifier changeEditModifier, ChangeEditJson changeEditJson, ProjectCache projectCache) {
        this.gitRepositoryManager = gitRepositoryManager;
        this.fixReplacementInterpreter = fixReplacementInterpreter;
        this.changeEditModifier = changeEditModifier;
        this.changeEditJson = changeEditJson;
        this.projectCache = projectCache;
    }

    public Response<EditInfo> apply(FixResource fixResource, Void nothing) throws AuthException, OrmException, ResourceConflictException, IOException, ResourceNotFoundException, PermissionBackendException {
        RevisionResource revisionResource = fixResource.getRevisionResource();
        Project.NameKey project = revisionResource.getProject();
        ProjectState projectState = this.projectCache.checkedGet(project);
        PatchSet patchSet = revisionResource.getPatchSet();
        ObjectId patchSetCommitId = ObjectId.fromString(patchSet.getRevision().get());
        Repository repository = this.gitRepositoryManager.openRepository(project);
        try {
            List<TreeModification> treeModifications = this.fixReplacementInterpreter.toTreeModifications(repository, projectState, patchSetCommitId, fixResource.getFixReplacements());
            ChangeEdit changeEdit = this.changeEditModifier.combineWithModifiedPatchSetTree(repository, revisionResource.getNotes(), patchSet, treeModifications);
            Response<EditInfo> response = Response.ok(this.changeEditJson.toEditInfo(changeEdit, false));
            if (repository != null) {
                repository.close();
            }
            return response;
        }
        catch (Throwable throwable) {
            try {
                if (repository != null) {
                    try {
                        repository.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InvalidChangeOperationException e) {
                throw new ResourceConflictException(e.getMessage());
            }
        }
    }
}

