/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.CommentJson;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;

@Singleton
public class ListChangeDrafts
implements RestReadView<ChangeResource> {
    protected final Provider<ReviewDb> db;
    protected final ChangeData.Factory changeDataFactory;
    protected final Provider<CommentJson> commentJson;
    protected final CommentsUtil commentsUtil;

    @Inject
    ListChangeDrafts(Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, Provider<CommentJson> commentJson, CommentsUtil commentsUtil) {
        this.db = db;
        this.changeDataFactory = changeDataFactory;
        this.commentJson = commentJson;
        this.commentsUtil = commentsUtil;
    }

    protected Iterable<Comment> listComments(ChangeResource rsrc) throws OrmException {
        ChangeData cd = this.changeDataFactory.create(this.db.get(), rsrc.getNotes());
        return this.commentsUtil.draftByChangeAuthor(this.db.get(), cd.notes(), rsrc.getUser().getAccountId());
    }

    protected boolean includeAuthorInfo() {
        return false;
    }

    public boolean requireAuthentication() {
        return true;
    }

    public Map<String, List<CommentInfo>> apply(ChangeResource rsrc) throws AuthException, OrmException {
        if (this.requireAuthentication() && !rsrc.getUser().isIdentifiedUser()) {
            throw new AuthException("Authentication required");
        }
        return this.getCommentFormatter().format(this.listComments(rsrc));
    }

    public List<CommentInfo> getComments(ChangeResource rsrc) throws AuthException, OrmException {
        if (this.requireAuthentication() && !rsrc.getUser().isIdentifiedUser()) {
            throw new AuthException("Authentication required");
        }
        return this.getCommentFormatter().formatAsList(this.listComments(rsrc));
    }

    private CommentJson.CommentFormatter getCommentFormatter() {
        return this.commentJson.get().setFillAccounts(this.includeAuthorInfo()).setFillPatchSet(true).newCommentFormatter();
    }
}

