/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.TestSubmitRuleInput;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.rules.RulesCache;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.project.SubmitRuleEvaluator;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.args4j.Option;

public class TestSubmitRule
implements RestModifyView<RevisionResource, TestSubmitRuleInput> {
    private final Provider<ReviewDb> db;
    private final ChangeData.Factory changeDataFactory;
    private final RulesCache rules;
    private final AccountLoader.Factory accountInfoFactory;
    private final SubmitRuleEvaluator.Factory submitRuleEvaluatorFactory;
    @Option(name="--filters", usage="impact of filters in parent projects")
    private TestSubmitRuleInput.Filters filters = TestSubmitRuleInput.Filters.RUN;

    @Inject
    TestSubmitRule(Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, RulesCache rules, AccountLoader.Factory infoFactory, SubmitRuleEvaluator.Factory submitRuleEvaluatorFactory) {
        this.db = db;
        this.changeDataFactory = changeDataFactory;
        this.rules = rules;
        this.accountInfoFactory = infoFactory;
        this.submitRuleEvaluatorFactory = submitRuleEvaluatorFactory;
    }

    public List<Record> apply(RevisionResource rsrc, TestSubmitRuleInput input) throws AuthException, OrmException {
        if (input == null) {
            input = new TestSubmitRuleInput();
        }
        if (input.rule != null && !this.rules.isProjectRulesEnabled()) {
            throw new AuthException("project rules are disabled");
        }
        input.filters = MoreObjects.firstNonNull(input.filters, this.filters);
        SubmitRuleEvaluator evaluator = this.submitRuleEvaluatorFactory.create(rsrc.getUser(), this.changeDataFactory.create(this.db.get(), rsrc.getNotes()));
        List<SubmitRecord> records = evaluator.setPatchSet(rsrc.getPatchSet()).setLogErrors(false).setSkipSubmitFilters(input.filters == TestSubmitRuleInput.Filters.SKIP).setRule(input.rule).evaluate();
        ArrayList<Record> out = Lists.newArrayListWithCapacity(records.size());
        AccountLoader accounts = this.accountInfoFactory.create(true);
        for (SubmitRecord r : records) {
            out.add(new Record(r, accounts));
        }
        if (!out.isEmpty()) {
            ((Record)out.get((int)0)).prologReductionCount = evaluator.getReductionsConsumed();
        }
        accounts.fill();
        return out;
    }

    static class None {
        None() {
        }
    }

    static class Record {
        SubmitRecord.Status status;
        String errorMessage;
        Map<String, AccountInfo> ok;
        Map<String, AccountInfo> reject;
        Map<String, None> need;
        Map<String, AccountInfo> may;
        Map<String, None> impossible;
        Long prologReductionCount;

        Record(SubmitRecord r, AccountLoader accounts) {
            this.status = r.status;
            this.errorMessage = r.errorMessage;
            if (r.labels != null) {
                for (SubmitRecord.Label n : r.labels) {
                    AccountInfo who = n.appliedBy != null ? accounts.get(n.appliedBy) : new AccountInfo(null);
                    this.label(n, who);
                }
            }
        }

        private void label(SubmitRecord.Label n, AccountInfo who) {
            switch (n.status) {
                case OK: {
                    if (this.ok == null) {
                        this.ok = new LinkedHashMap<String, AccountInfo>();
                    }
                    this.ok.put(n.label, who);
                    break;
                }
                case REJECT: {
                    if (this.reject == null) {
                        this.reject = new LinkedHashMap<String, AccountInfo>();
                    }
                    this.reject.put(n.label, who);
                    break;
                }
                case NEED: {
                    if (this.need == null) {
                        this.need = new LinkedHashMap<String, None>();
                    }
                    this.need.put(n.label, new None());
                    break;
                }
                case MAY: {
                    if (this.may == null) {
                        this.may = new LinkedHashMap<String, AccountInfo>();
                    }
                    this.may.put(n.label, who);
                    break;
                }
                case IMPOSSIBLE: {
                    if (this.impossible == null) {
                        this.impossible = new LinkedHashMap<String, None>();
                    }
                    this.impossible.put(n.label, new None());
                }
            }
        }
    }
}

