/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Ordering;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.change.AutoValue_WalkSorter_PatchSetData;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WalkSorter {
    private static final Logger log = LoggerFactory.getLogger(WalkSorter.class);
    private static final Ordering<List<PatchSetData>> PROJECT_LIST_SORTER = Ordering.natural().nullsFirst().onResultOf(in -> {
        if (in == null || in.isEmpty()) {
            return null;
        }
        try {
            return ((PatchSetData)in.get(0)).data().change().getProject();
        }
        catch (OrmException e) {
            throw new IllegalStateException(e);
        }
    });
    private final GitRepositoryManager repoManager;
    private final Set<PatchSet.Id> includePatchSets;
    private boolean retainBody;

    @Inject
    WalkSorter(GitRepositoryManager repoManager) {
        this.repoManager = repoManager;
        this.includePatchSets = new HashSet<PatchSet.Id>();
    }

    public WalkSorter includePatchSets(Iterable<PatchSet.Id> patchSets) {
        Iterables.addAll(this.includePatchSets, patchSets);
        return this;
    }

    public WalkSorter setRetainBody(boolean retainBody) {
        this.retainBody = retainBody;
        return this;
    }

    public Iterable<PatchSetData> sort(Iterable<ChangeData> in) throws OrmException, IOException {
        Multimap byProject = MultimapBuilder.hashKeys().arrayListValues().build();
        for (ChangeData cd : in) {
            byProject.put(cd.change().getProject(), cd);
        }
        ArrayList<List<PatchSetData>> sortedByProject = new ArrayList<List<PatchSetData>>(byProject.keySet().size());
        for (Map.Entry e : byProject.asMap().entrySet()) {
            sortedByProject.add(this.sortProject((Project.NameKey)e.getKey(), e.getValue()));
        }
        Collections.sort(sortedByProject, PROJECT_LIST_SORTER);
        return Iterables.concat(sortedByProject);
    }

    private List<PatchSetData> sortProject(Project.NameKey project, Collection<ChangeData> in) throws OrmException, IOException {
        try (Repository repo = this.repoManager.openRepository(project);){
            ListMultimap<RevCommit, PatchSetData> byCommit;
            RevWalk rw;
            block19: {
                block18: {
                    rw = new RevWalk(repo);
                    rw.setRetainBody(this.retainBody);
                    byCommit = this.byCommit(rw, in);
                    if (!byCommit.isEmpty()) break block18;
                    ImmutableList<PatchSetData> immutableList = ImmutableList.of();
                    rw.close();
                    return immutableList;
                }
                if (byCommit.size() != 1) break block19;
                ImmutableList<PatchSetData> immutableList = ImmutableList.of((PatchSetData)byCommit.values().iterator().next());
                rw.close();
                return immutableList;
            }
            try {
                RevCommit c;
                Set<RevCommit> commits = byCommit.keySet();
                ListMultimap<RevCommit, RevCommit> children = WalkSorter.collectChildren(commits);
                Multimap pending = MultimapBuilder.hashKeys().arrayListValues().build();
                ArrayDeque<RevCommit> todo = new ArrayDeque<RevCommit>();
                RevFlag done = rw.newFlag("done");
                WalkSorter.markStart(rw, commits);
                int expected = commits.size();
                int found = 0;
                ArrayList<PatchSetData> result = new ArrayList<PatchSetData>(expected);
                while (found < expected && (c = rw.next()) != null) {
                    if (!commits.contains(c)) continue;
                    todo.clear();
                    todo.add(c);
                    int i = 0;
                    while (!todo.isEmpty()) {
                        Preconditions.checkState(++i <= commits.size(), "Too many pending steps while sorting %s", commits);
                        RevCommit t = (RevCommit)todo.removeFirst();
                        if (t.has(done)) continue;
                        boolean ready = true;
                        for (RevCommit child : children.get((Object)t)) {
                            if (child.has(done)) continue;
                            pending.put(child, t);
                            ready = false;
                        }
                        if (!ready) continue;
                        found += WalkSorter.emit(t, byCommit, result, done);
                        todo.addAll(pending.get(t));
                    }
                }
                ArrayList<PatchSetData> arrayList = result;
                rw.close();
                return arrayList;
            }
            catch (Throwable throwable) {
                try {
                    rw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static ListMultimap<RevCommit, RevCommit> collectChildren(Set<RevCommit> commits) {
        Multimap children = MultimapBuilder.hashKeys().arrayListValues().build();
        for (RevCommit c : commits) {
            for (RevCommit p : c.getParents()) {
                if (!commits.contains(p)) continue;
                children.put(p, c);
            }
        }
        return children;
    }

    private static int emit(RevCommit c, ListMultimap<RevCommit, PatchSetData> byCommit, List<PatchSetData> result, RevFlag done) {
        if (c.has(done)) {
            return 0;
        }
        c.add(done);
        Collection psds = byCommit.get((Object)c);
        if (!psds.isEmpty()) {
            result.addAll(psds);
            return 1;
        }
        return 0;
    }

    private ListMultimap<RevCommit, PatchSetData> byCommit(RevWalk rw, Collection<ChangeData> in) throws OrmException, IOException {
        Multimap byCommit = MultimapBuilder.hashKeys(in.size()).arrayListValues(1).build();
        for (ChangeData cd : in) {
            PatchSet maxPs = null;
            for (PatchSet ps : cd.patchSets()) {
                if (!this.shouldInclude(ps) || maxPs != null && ps.getId().get() <= maxPs.getId().get()) continue;
                maxPs = ps;
            }
            if (maxPs == null) continue;
            ObjectId id = ObjectId.fromString(maxPs.getRevision().get());
            try {
                RevCommit c = rw.parseCommit(id);
                byCommit.put(c, PatchSetData.create(cd, maxPs, c));
            }
            catch (IncorrectObjectTypeException | MissingObjectException e) {
                log.warn("missing commit " + id.name() + " for patch set " + maxPs.getId(), e);
            }
        }
        return byCommit;
    }

    private boolean shouldInclude(PatchSet ps) {
        return this.includePatchSets.isEmpty() || this.includePatchSets.contains(ps.getId());
    }

    private static void markStart(RevWalk rw, Iterable<RevCommit> commits) throws IOException {
        for (RevCommit c : commits) {
            rw.markStart(c);
        }
    }

    @AutoValue
    static abstract class PatchSetData {
        PatchSetData() {
        }

        @VisibleForTesting
        static PatchSetData create(ChangeData cd, PatchSet ps, RevCommit commit) {
            return new AutoValue_WalkSorter_PatchSetData(cd, ps, commit);
        }

        abstract ChangeData data();

        abstract PatchSet patchSet();

        abstract RevCommit commit();
    }
}

