/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.server.config.ConfigUtil;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.MutableDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleConfig {
    private static final Logger log = LoggerFactory.getLogger(ScheduleConfig.class);
    public static final long MISSING_CONFIG = -1L;
    public static final long INVALID_CONFIG = -2L;
    private static final String KEY_INTERVAL = "interval";
    private static final String KEY_STARTTIME = "startTime";
    private final Config rc;
    private final String section;
    private final String subsection;
    private final String keyInterval;
    private final String keyStartTime;
    private final long initialDelay;
    private final long interval;

    public ScheduleConfig(Config rc, String section) {
        this(rc, section, null);
    }

    public ScheduleConfig(Config rc, String section, String subsection) {
        this(rc, section, subsection, DateTime.now());
    }

    public ScheduleConfig(Config rc, String section, String subsection, String keyInterval, String keyStartTime) {
        this(rc, section, subsection, keyInterval, keyStartTime, DateTime.now());
    }

    @VisibleForTesting
    ScheduleConfig(Config rc, String section, String subsection, DateTime now) {
        this(rc, section, subsection, KEY_INTERVAL, KEY_STARTTIME, now);
    }

    @VisibleForTesting
    ScheduleConfig(Config rc, String section, String subsection, String keyInterval, String keyStartTime, DateTime now) {
        this.rc = rc;
        this.section = section;
        this.subsection = subsection;
        this.keyInterval = keyInterval;
        this.keyStartTime = keyStartTime;
        this.interval = ScheduleConfig.interval(rc, section, subsection, keyInterval);
        this.initialDelay = this.interval > 0L ? ScheduleConfig.initialDelay(rc, section, subsection, keyStartTime, now, this.interval) : this.interval;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public long getInterval() {
        return this.interval;
    }

    private static long interval(Config rc, String section, String subsection, String keyInterval) {
        long interval = -1L;
        try {
            interval = ConfigUtil.getTimeUnit(rc, section, subsection, keyInterval, -1L, TimeUnit.MILLISECONDS);
            if (interval == -1L) {
                log.info(MessageFormat.format("{0} schedule parameter \"{0}.{1}\" is not configured", section, keyInterval));
            }
        }
        catch (IllegalArgumentException e) {
            log.error(MessageFormat.format("Invalid {0} schedule parameter \"{0}.{1}\"", section, keyInterval), e);
            interval = -2L;
        }
        return interval;
    }

    private static long initialDelay(Config rc, String section, String subsection, String keyStartTime, DateTime now, long interval) {
        long delay;
        block6: {
            delay = -1L;
            String start = rc.getString(section, subsection, keyStartTime);
            try {
                if (start != null) {
                    MutableDateTime startTime = now.toMutableDateTime();
                    try {
                        DateTimeFormatter formatter = ISODateTimeFormat.hourMinute();
                        LocalTime firstStartTime = formatter.parseLocalTime(start);
                        startTime.hourOfDay().set(firstStartTime.getHourOfDay());
                        startTime.minuteOfHour().set(firstStartTime.getMinuteOfHour());
                    }
                    catch (IllegalArgumentException e1) {
                        DateTimeFormatter formatter = DateTimeFormat.forPattern("E HH:mm").withLocale(Locale.US);
                        LocalDateTime firstStartDateTime = formatter.parseLocalDateTime(start);
                        startTime.dayOfWeek().set(firstStartDateTime.getDayOfWeek());
                        startTime.hourOfDay().set(firstStartDateTime.getHourOfDay());
                        startTime.minuteOfHour().set(firstStartDateTime.getMinuteOfHour());
                    }
                    startTime.secondOfMinute().set(0);
                    startTime.millisOfSecond().set(0);
                    long s = startTime.getMillis();
                    long n = now.getMillis();
                    delay = (s - n) % interval;
                    if (delay <= 0L) {
                        delay += interval;
                    }
                    break block6;
                }
                log.info(MessageFormat.format("{0} schedule parameter \"{0}.{1}\" is not configured", section, keyStartTime));
            }
            catch (IllegalArgumentException e2) {
                log.error(MessageFormat.format("Invalid {0} schedule parameter \"{0}.{1}\"", section, keyStartTime), e2);
                delay = -2L;
            }
        }
        return delay;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.formatValue(this.keyInterval));
        b.append(", ");
        b.append(this.formatValue(this.keyStartTime));
        return b.toString();
    }

    private String formatValue(String key) {
        StringBuilder b = new StringBuilder();
        b.append(this.section);
        if (this.subsection != null) {
            b.append(".");
            b.append(this.subsection);
        }
        b.append(".");
        b.append(key);
        String value = this.rc.getString(this.section, this.subsection, key);
        if (value != null) {
            b.append(" = ");
            b.append(value);
        } else {
            b.append(": NA");
        }
        return b.toString();
    }
}

