/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.edit.tree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.gerrit.extensions.restapi.RawInput;
import com.google.gerrit.server.edit.tree.TreeModification;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeFileContentModification
implements TreeModification {
    private static final Logger log = LoggerFactory.getLogger(ChangeFileContentModification.class);
    private final String filePath;
    private final RawInput newContent;

    public ChangeFileContentModification(String filePath, RawInput newContent) {
        this.filePath = filePath;
        this.newContent = Preconditions.checkNotNull(newContent, "new content required");
    }

    @Override
    public List<DirCacheEditor.PathEdit> getPathEdits(Repository repository, RevCommit baseCommit) {
        ChangeContent changeContentEdit = new ChangeContent(this.filePath, this.newContent, repository);
        return Collections.singletonList(changeContentEdit);
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @VisibleForTesting
    RawInput getNewContent() {
        return this.newContent;
    }

    private static class ChangeContent
    extends DirCacheEditor.PathEdit {
        private final RawInput newContent;
        private final Repository repository;

        ChangeContent(String filePath, RawInput newContent, Repository repository) {
            super(filePath);
            this.newContent = newContent;
            this.repository = repository;
        }

        @Override
        public void apply(DirCacheEntry dirCacheEntry) {
            try {
                if (dirCacheEntry.getFileMode() == FileMode.GITLINK) {
                    dirCacheEntry.setLength(0);
                    dirCacheEntry.setLastModified(0L);
                    ObjectId newObjectId = ObjectId.fromString(this.getNewContentBytes(), 0);
                    dirCacheEntry.setObjectId(newObjectId);
                } else {
                    if (dirCacheEntry.getRawMode() == 0) {
                        dirCacheEntry.setFileMode(FileMode.REGULAR_FILE);
                    }
                    ObjectId newBlobObjectId = this.createNewBlobAndGetItsId();
                    dirCacheEntry.setObjectId(newBlobObjectId);
                }
            }
            catch (IOException e) {
                String message = String.format("Could not change the content of %s", dirCacheEntry.getPathString());
                log.error(message, e);
            }
            catch (InvalidObjectIdException e) {
                log.error("Invalid object id in submodule link", e);
            }
        }

        private ObjectId createNewBlobAndGetItsId() throws IOException {
            try (ObjectInserter objectInserter = this.repository.newObjectInserter();){
                ObjectId blobObjectId = this.createNewBlobAndGetItsId(objectInserter);
                objectInserter.flush();
                ObjectId objectId = blobObjectId;
                return objectId;
            }
        }

        private ObjectId createNewBlobAndGetItsId(ObjectInserter objectInserter) throws IOException {
            long contentLength = this.newContent.getContentLength();
            if (contentLength < 0L) {
                return objectInserter.insert(3, this.getNewContentBytes());
            }
            InputStream contentInputStream = this.newContent.getInputStream();
            return objectInserter.insert(3, contentLength, contentInputStream);
        }

        private byte[] getNewContentBytes() throws IOException {
            return ByteStreams.toByteArray(this.newContent.getInputStream());
        }
    }
}

