/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.events;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.google.gerrit.common.EventDispatcher;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ApprovalInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.RevisionInfo;
import com.google.gerrit.extensions.events.AssigneeChangedListener;
import com.google.gerrit.extensions.events.ChangeAbandonedListener;
import com.google.gerrit.extensions.events.ChangeDeletedListener;
import com.google.gerrit.extensions.events.ChangeMergedListener;
import com.google.gerrit.extensions.events.ChangeRestoredListener;
import com.google.gerrit.extensions.events.CommentAddedListener;
import com.google.gerrit.extensions.events.GitReferenceUpdatedListener;
import com.google.gerrit.extensions.events.HashtagsEditedListener;
import com.google.gerrit.extensions.events.NewProjectCreatedListener;
import com.google.gerrit.extensions.events.PrivateStateChangedListener;
import com.google.gerrit.extensions.events.ReviewerAddedListener;
import com.google.gerrit.extensions.events.ReviewerDeletedListener;
import com.google.gerrit.extensions.events.RevisionCreatedListener;
import com.google.gerrit.extensions.events.TopicEditedListener;
import com.google.gerrit.extensions.events.VoteDeletedListener;
import com.google.gerrit.extensions.events.WorkInProgressStateChangedListener;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.data.AccountAttribute;
import com.google.gerrit.server.data.ApprovalAttribute;
import com.google.gerrit.server.data.ChangeAttribute;
import com.google.gerrit.server.data.PatchSetAttribute;
import com.google.gerrit.server.data.RefUpdateAttribute;
import com.google.gerrit.server.events.AssigneeChangedEvent;
import com.google.gerrit.server.events.ChangeAbandonedEvent;
import com.google.gerrit.server.events.ChangeDeletedEvent;
import com.google.gerrit.server.events.ChangeMergedEvent;
import com.google.gerrit.server.events.ChangeRestoredEvent;
import com.google.gerrit.server.events.CommentAddedEvent;
import com.google.gerrit.server.events.EventFactory;
import com.google.gerrit.server.events.HashtagsChangedEvent;
import com.google.gerrit.server.events.PatchSetCreatedEvent;
import com.google.gerrit.server.events.PrivateStateChangedEvent;
import com.google.gerrit.server.events.ProjectCreatedEvent;
import com.google.gerrit.server.events.RefUpdatedEvent;
import com.google.gerrit.server.events.ReviewerAddedEvent;
import com.google.gerrit.server.events.ReviewerDeletedEvent;
import com.google.gerrit.server.events.TopicChangedEvent;
import com.google.gerrit.server.events.VoteDeletedEvent;
import com.google.gerrit.server.events.WorkInProgressStateChangedEvent;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gwtorm.server.OrmException;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StreamEventsApiListener
implements AssigneeChangedListener,
ChangeAbandonedListener,
ChangeDeletedListener,
ChangeMergedListener,
ChangeRestoredListener,
WorkInProgressStateChangedListener,
PrivateStateChangedListener,
CommentAddedListener,
GitReferenceUpdatedListener,
HashtagsEditedListener,
NewProjectCreatedListener,
ReviewerAddedListener,
ReviewerDeletedListener,
RevisionCreatedListener,
TopicEditedListener,
VoteDeletedListener {
    private static final Logger log = LoggerFactory.getLogger(StreamEventsApiListener.class);
    private final DynamicItem<EventDispatcher> dispatcher;
    private final Provider<ReviewDb> db;
    private final EventFactory eventFactory;
    private final ProjectCache projectCache;
    private final GitRepositoryManager repoManager;
    private final PatchSetUtil psUtil;
    private final ChangeNotes.Factory changeNotesFactory;

    @Inject
    StreamEventsApiListener(DynamicItem<EventDispatcher> dispatcher, Provider<ReviewDb> db, EventFactory eventFactory, ProjectCache projectCache, GitRepositoryManager repoManager, PatchSetUtil psUtil, ChangeNotes.Factory changeNotesFactory) {
        this.dispatcher = dispatcher;
        this.db = db;
        this.eventFactory = eventFactory;
        this.projectCache = projectCache;
        this.repoManager = repoManager;
        this.psUtil = psUtil;
        this.changeNotesFactory = changeNotesFactory;
    }

    private ChangeNotes getNotes(ChangeInfo info) throws OrmException {
        try {
            return this.changeNotesFactory.createChecked(new Change.Id(info._number));
        }
        catch (NoSuchChangeException e) {
            throw new OrmException(e);
        }
    }

    private Change getChange(ChangeInfo info) throws OrmException {
        return this.getNotes(info).getChange();
    }

    private PatchSet getPatchSet(ChangeNotes notes, RevisionInfo info) throws OrmException {
        return this.psUtil.get(this.db.get(), notes, PatchSet.Id.fromRef(info.ref));
    }

    private Supplier<ChangeAttribute> changeAttributeSupplier(final Change change) {
        return Suppliers.memoize(new Supplier<ChangeAttribute>(){

            @Override
            public ChangeAttribute get() {
                return StreamEventsApiListener.this.eventFactory.asChangeAttribute(change);
            }
        });
    }

    private Supplier<AccountAttribute> accountAttributeSupplier(final AccountInfo account) {
        return Suppliers.memoize(new Supplier<AccountAttribute>(){

            @Override
            public AccountAttribute get() {
                return account != null ? StreamEventsApiListener.this.eventFactory.asAccountAttribute(new Account.Id(account._accountId)) : null;
            }
        });
    }

    private Supplier<PatchSetAttribute> patchSetAttributeSupplier(final Change change, final PatchSet patchSet) {
        return Suppliers.memoize(new Supplier<PatchSetAttribute>(){

            /*
             * Enabled aggressive exception aggregation
             */
            @Override
            public PatchSetAttribute get() {
                try (Repository repo = StreamEventsApiListener.this.repoManager.openRepository(change.getProject());){
                    RevWalk revWalk = new RevWalk(repo);
                    try {
                        PatchSetAttribute patchSetAttribute = StreamEventsApiListener.this.eventFactory.asPatchSetAttribute(revWalk, change, patchSet);
                        revWalk.close();
                        return patchSetAttribute;
                    }
                    catch (Throwable throwable) {
                        try {
                            revWalk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static Map<String, Short> convertApprovalsMap(Map<String, ApprovalInfo> approvals) {
        HashMap<String, Short> result = new HashMap<String, Short>();
        for (Map.Entry<String, ApprovalInfo> e : approvals.entrySet()) {
            Short value = e.getValue().value == null ? null : Short.valueOf(e.getValue().value.shortValue());
            result.put(e.getKey(), value);
        }
        return result;
    }

    private ApprovalAttribute getApprovalAttribute(LabelTypes labelTypes, Map.Entry<String, Short> approval, Map<String, Short> oldApprovals) {
        LabelType lt;
        ApprovalAttribute a = new ApprovalAttribute();
        a.type = approval.getKey();
        if (oldApprovals != null && !oldApprovals.isEmpty() && oldApprovals.get(approval.getKey()) != null) {
            a.oldValue = Short.toString(oldApprovals.get(approval.getKey()));
        }
        if ((lt = labelTypes.byLabel(approval.getKey())) != null) {
            a.description = lt.getName();
        }
        if (approval.getValue() != null) {
            a.value = Short.toString(approval.getValue());
        }
        return a;
    }

    private Supplier<ApprovalAttribute[]> approvalsAttributeSupplier(final Change change, Map<String, ApprovalInfo> newApprovals, final Map<String, ApprovalInfo> oldApprovals) {
        final Map<String, Short> approvals = StreamEventsApiListener.convertApprovalsMap(newApprovals);
        return Suppliers.memoize(new Supplier<ApprovalAttribute[]>(){

            @Override
            public ApprovalAttribute[] get() {
                LabelTypes labelTypes = StreamEventsApiListener.this.projectCache.get(change.getProject()).getLabelTypes();
                if (approvals.size() > 0) {
                    ApprovalAttribute[] r = new ApprovalAttribute[approvals.size()];
                    int i = 0;
                    for (Map.Entry approval : approvals.entrySet()) {
                        r[i++] = StreamEventsApiListener.this.getApprovalAttribute(labelTypes, approval, StreamEventsApiListener.convertApprovalsMap(oldApprovals));
                    }
                    return r;
                }
                return null;
            }
        });
    }

    String[] hashtagArray(Collection<String> hashtags) {
        if (hashtags != null && hashtags.size() > 0) {
            return Sets.newHashSet(hashtags).toArray(new String[hashtags.size()]);
        }
        return null;
    }

    @Override
    public void onAssigneeChanged(AssigneeChangedListener.Event ev) {
        try {
            Change change = this.getChange(ev.getChange());
            AssigneeChangedEvent event = new AssigneeChangedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.changer = this.accountAttributeSupplier(ev.getWho());
            event.oldAssignee = this.accountAttributeSupplier(ev.getOldAssignee());
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onTopicEdited(TopicEditedListener.Event ev) {
        try {
            Change change = this.getChange(ev.getChange());
            TopicChangedEvent event = new TopicChangedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.changer = this.accountAttributeSupplier(ev.getWho());
            event.oldTopic = ev.getOldTopic();
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onRevisionCreated(RevisionCreatedListener.Event ev) {
        try {
            ChangeNotes notes = this.getNotes(ev.getChange());
            Change change = notes.getChange();
            PatchSet patchSet = this.getPatchSet(notes, ev.getRevision());
            PatchSetCreatedEvent event = new PatchSetCreatedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.patchSet = this.patchSetAttributeSupplier(change, patchSet);
            event.uploader = this.accountAttributeSupplier(ev.getWho());
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onReviewerDeleted(ReviewerDeletedListener.Event ev) {
        try {
            ChangeNotes notes = this.getNotes(ev.getChange());
            Change change = notes.getChange();
            ReviewerDeletedEvent event = new ReviewerDeletedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.patchSet = this.patchSetAttributeSupplier(change, this.psUtil.current(this.db.get(), notes));
            event.reviewer = this.accountAttributeSupplier(ev.getReviewer());
            event.remover = this.accountAttributeSupplier(ev.getWho());
            event.comment = ev.getComment();
            event.approvals = this.approvalsAttributeSupplier(change, ev.getNewApprovals(), ev.getOldApprovals());
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onReviewersAdded(ReviewerAddedListener.Event ev) {
        try {
            ChangeNotes notes = this.getNotes(ev.getChange());
            Change change = notes.getChange();
            ReviewerAddedEvent event = new ReviewerAddedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.patchSet = this.patchSetAttributeSupplier(change, this.psUtil.current(this.db.get(), notes));
            for (AccountInfo reviewer : ev.getReviewers()) {
                event.reviewer = this.accountAttributeSupplier(reviewer);
                this.dispatcher.get().postEvent(change, event);
            }
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onNewProjectCreated(NewProjectCreatedListener.Event ev) {
        ProjectCreatedEvent event = new ProjectCreatedEvent();
        event.projectName = ev.getProjectName();
        event.headName = ev.getHeadName();
        this.dispatcher.get().postEvent(event.getProjectNameKey(), event);
    }

    @Override
    public void onHashtagsEdited(HashtagsEditedListener.Event ev) {
        try {
            Change change = this.getChange(ev.getChange());
            HashtagsChangedEvent event = new HashtagsChangedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.editor = this.accountAttributeSupplier(ev.getWho());
            event.hashtags = this.hashtagArray(ev.getHashtags());
            event.added = this.hashtagArray(ev.getAddedHashtags());
            event.removed = this.hashtagArray(ev.getRemovedHashtags());
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onGitReferenceUpdated(final GitReferenceUpdatedListener.Event ev) {
        RefUpdatedEvent event = new RefUpdatedEvent();
        if (ev.getUpdater() != null) {
            event.submitter = this.accountAttributeSupplier(ev.getUpdater());
        }
        final Branch.NameKey refName = new Branch.NameKey(ev.getProjectName(), ev.getRefName());
        event.refUpdate = Suppliers.memoize(new Supplier<RefUpdateAttribute>(){

            @Override
            public RefUpdateAttribute get() {
                return StreamEventsApiListener.this.eventFactory.asRefUpdateAttribute(ObjectId.fromString(ev.getOldObjectId()), ObjectId.fromString(ev.getNewObjectId()), refName);
            }
        });
        try {
            this.dispatcher.get().postEvent(refName, event);
        }
        catch (PermissionBackendException e) {
            log.error("error while posting event", e);
        }
    }

    @Override
    public void onCommentAdded(CommentAddedListener.Event ev) {
        try {
            ChangeNotes notes = this.getNotes(ev.getChange());
            Change change = notes.getChange();
            PatchSet ps = this.getPatchSet(notes, ev.getRevision());
            CommentAddedEvent event = new CommentAddedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.author = this.accountAttributeSupplier(ev.getWho());
            event.patchSet = this.patchSetAttributeSupplier(change, ps);
            event.comment = ev.getComment();
            event.approvals = this.approvalsAttributeSupplier(change, ev.getApprovals(), ev.getOldApprovals());
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onChangeRestored(ChangeRestoredListener.Event ev) {
        try {
            ChangeNotes notes = this.getNotes(ev.getChange());
            Change change = notes.getChange();
            ChangeRestoredEvent event = new ChangeRestoredEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.restorer = this.accountAttributeSupplier(ev.getWho());
            event.patchSet = this.patchSetAttributeSupplier(change, this.psUtil.current(this.db.get(), notes));
            event.reason = ev.getReason();
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onChangeMerged(ChangeMergedListener.Event ev) {
        try {
            ChangeNotes notes = this.getNotes(ev.getChange());
            Change change = notes.getChange();
            ChangeMergedEvent event = new ChangeMergedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.submitter = this.accountAttributeSupplier(ev.getWho());
            event.patchSet = this.patchSetAttributeSupplier(change, this.psUtil.current(this.db.get(), notes));
            event.newRev = ev.getNewRevisionId();
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onChangeAbandoned(ChangeAbandonedListener.Event ev) {
        try {
            ChangeNotes notes = this.getNotes(ev.getChange());
            Change change = notes.getChange();
            ChangeAbandonedEvent event = new ChangeAbandonedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.abandoner = this.accountAttributeSupplier(ev.getWho());
            event.patchSet = this.patchSetAttributeSupplier(change, this.psUtil.current(this.db.get(), notes));
            event.reason = ev.getReason();
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onWorkInProgressStateChanged(WorkInProgressStateChangedListener.Event ev) {
        try {
            ChangeNotes notes = this.getNotes(ev.getChange());
            Change change = notes.getChange();
            PatchSet patchSet = this.getPatchSet(notes, ev.getRevision());
            WorkInProgressStateChangedEvent event = new WorkInProgressStateChangedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.changer = this.accountAttributeSupplier(ev.getWho());
            event.patchSet = this.patchSetAttributeSupplier(change, patchSet);
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onPrivateStateChanged(PrivateStateChangedListener.Event ev) {
        try {
            ChangeNotes notes = this.getNotes(ev.getChange());
            Change change = notes.getChange();
            PatchSet patchSet = this.getPatchSet(notes, ev.getRevision());
            PrivateStateChangedEvent event = new PrivateStateChangedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.changer = this.accountAttributeSupplier(ev.getWho());
            event.patchSet = this.patchSetAttributeSupplier(change, patchSet);
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onVoteDeleted(VoteDeletedListener.Event ev) {
        try {
            ChangeNotes notes = this.getNotes(ev.getChange());
            Change change = notes.getChange();
            VoteDeletedEvent event = new VoteDeletedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.patchSet = this.patchSetAttributeSupplier(change, this.psUtil.current(this.db.get(), notes));
            event.comment = ev.getMessage();
            event.reviewer = this.accountAttributeSupplier(ev.getReviewer());
            event.remover = this.accountAttributeSupplier(ev.getWho());
            event.approvals = this.approvalsAttributeSupplier(change, ev.getApprovals(), ev.getOldApprovals());
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    @Override
    public void onChangeDeleted(ChangeDeletedListener.Event ev) {
        try {
            ChangeNotes notes = this.getNotes(ev.getChange());
            Change change = notes.getChange();
            ChangeDeletedEvent event = new ChangeDeletedEvent(change);
            event.change = this.changeAttributeSupplier(change);
            event.deleter = this.accountAttributeSupplier(ev.getWho());
            this.dispatcher.get().postEvent(change, event);
        }
        catch (PermissionBackendException | OrmException e) {
            log.error("Failed to dispatch event", e);
        }
    }

    public static class Module
    extends AbstractModule {
        @Override
        protected void configure() {
            DynamicSet.bind(this.binder(), AssigneeChangedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), ChangeAbandonedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), ChangeDeletedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), ChangeMergedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), ChangeRestoredListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), CommentAddedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), GitReferenceUpdatedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), HashtagsEditedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), NewProjectCreatedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), PrivateStateChangedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), ReviewerAddedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), ReviewerDeletedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), RevisionCreatedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), TopicEditedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), VoteDeletedListener.class).to(StreamEventsApiListener.class);
            DynamicSet.bind(this.binder(), WorkInProgressStateChangedListener.class).to(StreamEventsApiListener.class);
        }
    }
}

