/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.AutoValue_MergeSuperSet_QueryKey;
import com.google.gerrit.server.git.ChangeSet;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.MergeOpRepoManager;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.SubmitRuleEvaluator;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeSuperSet {
    private static final Logger log = LoggerFactory.getLogger(MergeSuperSet.class);
    private final ChangeData.Factory changeDataFactory;
    private final Provider<InternalChangeQuery> queryProvider;
    private final Provider<MergeOpRepoManager> repoManagerProvider;
    private final PermissionBackend permissionBackend;
    private final Config cfg;
    private final Map<QueryKey, List<ChangeData>> queryCache;
    private final Map<Branch.NameKey, Optional<RevCommit>> heads;
    private final SubmitRuleEvaluator.Factory submitRuleEvaluatorFactory;
    private MergeOpRepoManager orm;
    private boolean closeOrm;

    public static void reloadChanges(ChangeSet cs) throws OrmException {
        for (ChangeData cd : cs.changes()) {
            cd.reloadChange();
            cd.setPatchSets(null);
            cd.setMergeable(null);
        }
    }

    @Inject
    MergeSuperSet(@GerritServerConfig Config cfg, ChangeData.Factory changeDataFactory, Provider<InternalChangeQuery> queryProvider, Provider<MergeOpRepoManager> repoManagerProvider, PermissionBackend permissionBackend, SubmitRuleEvaluator.Factory submitRuleEvaluatorFactory) {
        this.cfg = cfg;
        this.changeDataFactory = changeDataFactory;
        this.queryProvider = queryProvider;
        this.repoManagerProvider = repoManagerProvider;
        this.permissionBackend = permissionBackend;
        this.submitRuleEvaluatorFactory = submitRuleEvaluatorFactory;
        this.queryCache = new HashMap<QueryKey, List<ChangeData>>();
        this.heads = new HashMap<Branch.NameKey, Optional<RevCommit>>();
    }

    public MergeSuperSet setMergeOpRepoManager(MergeOpRepoManager orm) {
        Preconditions.checkState(this.orm == null);
        this.orm = Preconditions.checkNotNull(orm);
        this.closeOrm = false;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeSet completeChangeSet(ReviewDb db, Change change, CurrentUser user) throws IOException, OrmException, PermissionBackendException {
        try {
            ChangeData cd = this.changeDataFactory.create(db, change.getProject(), change.getId());
            ChangeSet cs = new ChangeSet(cd, ((PermissionBackend.ForChange)this.permissionBackend.user(user).change(cd).database(db)).test(ChangePermission.READ));
            if (Submit.wholeTopicEnabled(this.cfg)) {
                ChangeSet changeSet = this.completeChangeSetIncludingTopics(db, cs, user);
                return changeSet;
            }
            ChangeSet changeSet = this.completeChangeSetWithoutTopic(db, cs, user);
            return changeSet;
        }
        finally {
            if (this.closeOrm && this.orm != null) {
                this.orm.close();
                this.orm = null;
            }
        }
    }

    private SubmitType submitType(CurrentUser user, ChangeData cd, PatchSet ps) throws OrmException {
        SubmitTypeRecord str;
        SubmitTypeRecord submitTypeRecord = str = ps == cd.currentPatchSet() ? cd.submitTypeRecord() : this.submitRuleEvaluatorFactory.create(user, cd).setPatchSet(ps).getSubmitType();
        if (!str.isOk()) {
            this.logErrorAndThrow("Failed to get submit type for " + cd.getId() + ": " + str.errorMessage);
        }
        return str.type;
    }

    private static ImmutableListMultimap<Branch.NameKey, ChangeData> byBranch(Iterable<ChangeData> changes) throws OrmException {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (ChangeData cd : changes) {
            builder.put(cd.change().getDest(), cd);
        }
        return builder.build();
    }

    private Set<String> walkChangesByHashes(Collection<RevCommit> sourceCommits, Set<String> ignoreHashes, MergeOpRepoManager.OpenRepo or, Branch.NameKey b) throws IOException {
        String name;
        HashSet<String> destHashes = new HashSet<String>();
        or.rw.reset();
        this.markHeadUninteresting(or, b);
        for (RevCommit c : sourceCommits) {
            name = c.name();
            if (ignoreHashes.contains(name)) continue;
            destHashes.add(name);
            or.rw.markStart(c);
        }
        for (RevCommit c : or.rw) {
            name = c.name();
            if (ignoreHashes.contains(name)) continue;
            destHashes.add(name);
        }
        return destHashes;
    }

    private ChangeSet completeChangeSetWithoutTopic(ReviewDb db, ChangeSet changes, CurrentUser user) throws IOException, OrmException, PermissionBackendException {
        ArrayList<ChangeData> visibleChanges = new ArrayList<ChangeData>();
        ArrayList<ChangeData> nonVisibleChanges = new ArrayList<ChangeData>();
        ImmutableListMultimap<Branch.NameKey, ChangeData> bc = MergeSuperSet.byBranch(Iterables.concat(changes.changes(), changes.nonVisibleChanges()));
        for (Branch.NameKey b : bc.keySet()) {
            MergeOpRepoManager.OpenRepo or = this.getRepo(b.getParentKey());
            ArrayList<RevCommit> visibleCommits = new ArrayList<RevCommit>();
            ArrayList<RevCommit> nonVisibleCommits = new ArrayList<RevCommit>();
            for (ChangeData cd : bc.get((Object)b)) {
                PatchSet ps;
                boolean visible = changes.ids().contains(cd.getId());
                if (visible && !this.canRead(db, user, cd)) {
                    visible = false;
                }
                if (this.submitType(user, cd, ps = cd.currentPatchSet()) == SubmitType.CHERRY_PICK) {
                    if (visible) {
                        visibleChanges.add(cd);
                        continue;
                    }
                    nonVisibleChanges.add(cd);
                    continue;
                }
                String objIdStr = ps.getRevision().get();
                CodeReviewCommit commit = or.rw.parseCommit(ObjectId.fromString(objIdStr));
                if (visible) {
                    visibleCommits.add(commit);
                    continue;
                }
                nonVisibleCommits.add(commit);
            }
            Set<String> visibleHashes = this.walkChangesByHashes(visibleCommits, Collections.emptySet(), or, b);
            Iterables.addAll(visibleChanges, this.byCommitsOnBranchNotMerged(or, db, b, visibleHashes));
            Set<String> nonVisibleHashes = this.walkChangesByHashes(nonVisibleCommits, visibleHashes, or, b);
            Iterables.addAll(nonVisibleChanges, this.byCommitsOnBranchNotMerged(or, db, b, nonVisibleHashes));
        }
        return new ChangeSet(visibleChanges, nonVisibleChanges);
    }

    private MergeOpRepoManager.OpenRepo getRepo(Project.NameKey project) throws IOException {
        if (this.orm == null) {
            this.orm = this.repoManagerProvider.get();
            this.closeOrm = true;
        }
        try {
            MergeOpRepoManager.OpenRepo or = this.orm.getRepo(project);
            Preconditions.checkState(or.rw.hasRevSort(RevSort.TOPO));
            return or;
        }
        catch (NoSuchProjectException e) {
            throw new IOException(e);
        }
    }

    private void markHeadUninteresting(MergeOpRepoManager.OpenRepo or, Branch.NameKey b) throws IOException {
        Optional<RevCommit> head = this.heads.get(b);
        if (head == null) {
            Ref ref = or.repo.getRefDatabase().exactRef(b.get());
            head = ref != null ? Optional.of(or.rw.parseCommit(ref.getObjectId())) : Optional.empty();
            this.heads.put(b, head);
        }
        if (head.isPresent()) {
            or.rw.markUninteresting(head.get());
        }
    }

    private List<ChangeData> byCommitsOnBranchNotMerged(MergeOpRepoManager.OpenRepo or, ReviewDb db, Branch.NameKey branch, Set<String> hashes) throws OrmException, IOException {
        if (hashes.isEmpty()) {
            return ImmutableList.of();
        }
        QueryKey k = QueryKey.create(branch, hashes);
        List<ChangeData> cached = this.queryCache.get(k);
        if (cached != null) {
            return cached;
        }
        ArrayList<ChangeData> result = new ArrayList<ChangeData>();
        Iterable<ChangeData> destChanges = this.query().byCommitsOnBranchNotMerged(or.repo, db, branch, hashes);
        for (ChangeData chd : destChanges) {
            result.add(chd);
        }
        this.queryCache.put(k, result);
        return result;
    }

    private ChangeSet topicClosure(ReviewDb db, ChangeSet cs, CurrentUser user, Set<String> topicsSeen, Set<String> visibleTopicsSeen) throws OrmException, PermissionBackendException {
        String topic;
        ArrayList<ChangeData> visibleChanges = new ArrayList<ChangeData>();
        ArrayList<ChangeData> nonVisibleChanges = new ArrayList<ChangeData>();
        for (ChangeData cd : cs.changes()) {
            visibleChanges.add(cd);
            topic = cd.change().getTopic();
            if (Strings.isNullOrEmpty(topic) || visibleTopicsSeen.contains(topic)) continue;
            for (ChangeData topicCd : this.query().byTopicOpen(topic)) {
                if (this.canRead(db, user, topicCd)) {
                    visibleChanges.add(topicCd);
                    continue;
                }
                nonVisibleChanges.add(topicCd);
            }
            topicsSeen.add(topic);
            visibleTopicsSeen.add(topic);
        }
        for (ChangeData cd : cs.nonVisibleChanges()) {
            nonVisibleChanges.add(cd);
            topic = cd.change().getTopic();
            if (Strings.isNullOrEmpty(topic) || topicsSeen.contains(topic)) continue;
            for (ChangeData topicCd : this.query().byTopicOpen(topic)) {
                nonVisibleChanges.add(topicCd);
            }
            topicsSeen.add(topic);
        }
        return new ChangeSet(visibleChanges, nonVisibleChanges);
    }

    private ChangeSet completeChangeSetIncludingTopics(ReviewDb db, ChangeSet changes, CurrentUser user) throws IOException, OrmException, PermissionBackendException {
        int oldSeen;
        HashSet<String> topicsSeen = new HashSet<String>();
        HashSet<String> visibleTopicsSeen = new HashSet<String>();
        int seen = 0;
        do {
            oldSeen = seen;
            changes = this.completeChangeSetWithoutTopic(db, changes, user);
            changes = this.topicClosure(db, changes, user, topicsSeen, visibleTopicsSeen);
        } while ((seen = topicsSeen.size() + visibleTopicsSeen.size()) != oldSeen);
        return changes;
    }

    private InternalChangeQuery query() {
        ImmutableSet<String> fields = ImmutableSet.of(ChangeField.CHANGE.getName(), ChangeField.PATCH_SET.getName(), ChangeField.MERGEABLE.getName());
        return this.queryProvider.get().setRequestedFields(fields);
    }

    private void logError(String msg) {
        if (log.isErrorEnabled()) {
            log.error(msg);
        }
    }

    private void logErrorAndThrow(String msg) throws OrmException {
        this.logError(msg);
        throw new OrmException(msg);
    }

    private boolean canRead(ReviewDb db, CurrentUser user, ChangeData cd) throws PermissionBackendException {
        return ((PermissionBackend.ForChange)this.permissionBackend.user(user).change(cd).database(db)).test(ChangePermission.READ);
    }

    @AutoValue
    static abstract class QueryKey {
        QueryKey() {
        }

        private static QueryKey create(Branch.NameKey branch, Iterable<String> hashes) {
            return new AutoValue_MergeSuperSet_QueryKey(branch, ImmutableSet.copyOf(hashes));
        }

        abstract Branch.NameKey branch();

        abstract ImmutableSet<String> hashes();
    }
}

