/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.GetSubgroup;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.GroupsUpdate;
import com.google.gerrit.server.group.SubgroupResource;
import com.google.gerrit.server.group.UserInitiated;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@Singleton
public class AddSubgroups
implements RestModifyView<GroupResource, Input> {
    private final GroupsCollection groupsCollection;
    private final Provider<ReviewDb> db;
    private final Provider<GroupsUpdate> groupsUpdateProvider;
    private final GroupJson json;

    @Inject
    public AddSubgroups(GroupsCollection groupsCollection, Provider<ReviewDb> db, @UserInitiated Provider<GroupsUpdate> groupsUpdateProvider, GroupJson json) {
        this.groupsCollection = groupsCollection;
        this.db = db;
        this.groupsUpdateProvider = groupsUpdateProvider;
        this.json = json;
    }

    public List<GroupInfo> apply(GroupResource resource, Input input) throws MethodNotAllowedException, AuthException, UnprocessableEntityException, OrmException, ResourceNotFoundException, IOException {
        GroupDescription.Internal group = resource.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        input = Input.init(input);
        GroupControl control = resource.getControl();
        if (!control.canAddGroup()) {
            throw new AuthException(String.format("Cannot add groups to group %s", group.getName()));
        }
        ArrayList<GroupInfo> result = new ArrayList<GroupInfo>();
        HashSet<AccountGroup.UUID> subgroupUuids = new HashSet<AccountGroup.UUID>();
        for (String subgroupIdentifier : input.groups) {
            GroupDescription.Basic subgroup = this.groupsCollection.parse(subgroupIdentifier);
            subgroupUuids.add(subgroup.getGroupUUID());
            result.add(this.json.format(subgroup));
        }
        AccountGroup.UUID groupUuid = group.getGroupUUID();
        try {
            this.groupsUpdateProvider.get().addSubgroups(this.db.get(), groupUuid, subgroupUuids);
        }
        catch (NoSuchGroupException e) {
            throw new ResourceNotFoundException(String.format("Group %s not found", groupUuid));
        }
        return result;
    }

    @Singleton
    static class UpdateSubgroup
    implements RestModifyView<SubgroupResource, PutSubgroup.Input> {
        private final Provider<GetSubgroup> get;

        @Inject
        UpdateSubgroup(Provider<GetSubgroup> get) {
            this.get = get;
        }

        public GroupInfo apply(SubgroupResource resource, PutSubgroup.Input input) throws OrmException {
            return this.get.get().apply(resource);
        }
    }

    static class PutSubgroup
    implements RestModifyView<GroupResource, Input> {
        private final AddSubgroups addSubgroups;
        private final String id;

        PutSubgroup(AddSubgroups addSubgroups, String id) {
            this.addSubgroups = addSubgroups;
            this.id = id;
        }

        public GroupInfo apply(GroupResource resource, Input input) throws AuthException, MethodNotAllowedException, ResourceNotFoundException, OrmException, IOException {
            com.google.gerrit.server.group.AddSubgroups$Input in = new com.google.gerrit.server.group.AddSubgroups$Input();
            in.groups = ImmutableList.of(this.id);
            try {
                List<GroupInfo> list = this.addSubgroups.apply(resource, in);
                if (list.size() == 1) {
                    return list.get(0);
                }
                throw new IllegalStateException();
            }
            catch (UnprocessableEntityException e) {
                throw new ResourceNotFoundException(this.id);
            }
        }

        static class Input {
            Input() {
            }
        }
    }

    public static class Input {
        @DefaultInput
        String _oneGroup;
        public List<String> groups;

        public static Input fromGroups(List<String> groups) {
            Input in = new Input();
            in.groups = groups;
            return in;
        }

        static Input init(Input in) {
            if (in == null) {
                in = new Input();
            }
            if (in.groups == null) {
                in.groups = Lists.newArrayListWithCapacity(1);
            }
            if (!Strings.isNullOrEmpty(in._oneGroup)) {
                in.groups.add(in._oneGroup);
            }
            return in;
        }
    }
}

