/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.api.groups.GroupInput;
import com.google.gerrit.extensions.client.ListGroupsOption;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.CreateGroupArgs;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupUUID;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.GroupsUpdate;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.group.UserInitiated;
import com.google.gerrit.server.validators.GroupCreationValidationListener;
import com.google.gerrit.server.validators.ValidationException;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;

@RequiresCapability(value="createGroup")
public class CreateGroup
implements RestModifyView<TopLevelResource, GroupInput> {
    private final Provider<IdentifiedUser> self;
    private final PersonIdent serverIdent;
    private final ReviewDb db;
    private final Provider<GroupsUpdate> groupsUpdateProvider;
    private final GroupCache groupCache;
    private final GroupsCollection groups;
    private final GroupJson json;
    private final DynamicSet<GroupCreationValidationListener> groupCreationValidationListeners;
    private final AddMembers addMembers;
    private final SystemGroupBackend systemGroupBackend;
    private final boolean defaultVisibleToAll;
    private final String name;

    @Inject
    CreateGroup(Provider<IdentifiedUser> self, @GerritPersonIdent PersonIdent serverIdent, ReviewDb db, @UserInitiated Provider<GroupsUpdate> groupsUpdateProvider, GroupCache groupCache, GroupsCollection groups, GroupJson json, DynamicSet<GroupCreationValidationListener> groupCreationValidationListeners, AddMembers addMembers, SystemGroupBackend systemGroupBackend, @GerritServerConfig Config cfg, @Assisted String name) {
        this.self = self;
        this.serverIdent = serverIdent;
        this.db = db;
        this.groupsUpdateProvider = groupsUpdateProvider;
        this.groupCache = groupCache;
        this.groups = groups;
        this.json = json;
        this.groupCreationValidationListeners = groupCreationValidationListeners;
        this.addMembers = addMembers;
        this.systemGroupBackend = systemGroupBackend;
        this.defaultVisibleToAll = cfg.getBoolean("groups", "newGroupsVisibleToAll", false);
        this.name = name;
    }

    public CreateGroup addOption(ListGroupsOption o) {
        this.json.addOption(o);
        return this;
    }

    public CreateGroup addOptions(Collection<ListGroupsOption> o) {
        this.json.addOptions(o);
        return this;
    }

    public GroupInfo apply(TopLevelResource resource, GroupInput input) throws AuthException, BadRequestException, UnprocessableEntityException, ResourceConflictException, OrmException, IOException, ConfigInvalidException, ResourceNotFoundException {
        if (input == null) {
            input = new GroupInput();
        }
        if (input.name != null && !this.name.equals(input.name)) {
            throw new BadRequestException("name must match URL");
        }
        AccountGroup.Id ownerId = this.owner(input);
        CreateGroupArgs args = new CreateGroupArgs();
        args.setGroupName(this.name);
        args.groupDescription = Strings.emptyToNull(input.description);
        args.visibleToAll = MoreObjects.firstNonNull(input.visibleToAll, this.defaultVisibleToAll);
        args.ownerGroupId = ownerId;
        if (input.members != null && !input.members.isEmpty()) {
            ArrayList<? extends Account.Id> members = new ArrayList<Account.Id>();
            for (String nameOrEmailOrId : input.members) {
                Account a = this.addMembers.findAccount(nameOrEmailOrId);
                if (!a.isActive()) {
                    throw new UnprocessableEntityException(String.format("Account Inactive: %s", nameOrEmailOrId));
                }
                members.add(a.getId());
            }
            args.initialMembers = members;
        } else {
            args.initialMembers = ownerId == null ? Collections.singleton(this.self.get().getAccountId()) : Collections.emptySet();
        }
        for (GroupCreationValidationListener l : this.groupCreationValidationListeners) {
            try {
                l.validateNewGroup(args);
            }
            catch (ValidationException e) {
                throw new ResourceConflictException(e.getMessage(), e);
            }
        }
        return this.json.format(GroupDescriptions.forAccountGroup(this.createGroup(args)));
    }

    private AccountGroup.Id owner(GroupInput input) throws UnprocessableEntityException {
        if (input.ownerId != null) {
            GroupDescription.Internal d = this.groups.parseInternal(Url.decode(input.ownerId));
            return d.getId();
        }
        return null;
    }

    private AccountGroup createGroup(CreateGroupArgs createGroupArgs) throws OrmException, ResourceConflictException, IOException {
        String nameLower = createGroupArgs.getGroupName().toLowerCase(Locale.US);
        for (String name : this.systemGroupBackend.getNames()) {
            if (!name.toLowerCase(Locale.US).equals(nameLower)) continue;
            throw new ResourceConflictException("group '" + name + "' already exists");
        }
        for (String name : this.systemGroupBackend.getReservedNames()) {
            if (!name.toLowerCase(Locale.US).equals(nameLower)) continue;
            throw new ResourceConflictException("group name '" + name + "' is reserved");
        }
        AccountGroup.Id groupId = new AccountGroup.Id(this.db.nextAccountGroupId());
        AccountGroup.UUID uuid = GroupUUID.make(createGroupArgs.getGroupName(), this.self.get().newCommitterIdent(this.serverIdent.getWhen(), this.serverIdent.getTimeZone()));
        AccountGroup group = new AccountGroup(createGroupArgs.getGroup(), groupId, uuid, TimeUtil.nowTs());
        group.setVisibleToAll(createGroupArgs.visibleToAll);
        if (createGroupArgs.ownerGroupId != null) {
            Optional<InternalGroup> ownerGroup = this.groupCache.get(createGroupArgs.ownerGroupId);
            ownerGroup.map(InternalGroup::getGroupUUID).ifPresent(group::setOwnerGroupUUID);
        }
        if (createGroupArgs.groupDescription != null) {
            group.setDescription(createGroupArgs.groupDescription);
        }
        try {
            this.groupsUpdateProvider.get().addGroup(this.db, group, ImmutableSet.copyOf(createGroupArgs.initialMembers));
        }
        catch (OrmDuplicateKeyException e) {
            throw new ResourceConflictException("group '" + createGroupArgs.getGroupName() + "' already exists");
        }
        return group;
    }

    public static interface Factory {
        public CreateGroup create(@Assisted String var1);
    }
}

