/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.change;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gerrit.index.IndexConfig;
import com.google.gerrit.index.IndexedQuery;
import com.google.gerrit.index.QueryOptions;
import com.google.gerrit.index.query.DataSource;
import com.google.gerrit.index.query.Matchable;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexedChangeQuery
extends IndexedQuery<Change.Id, ChangeData>
implements ChangeDataSource,
Matchable<ChangeData> {
    private final Map<ChangeData, DataSource<ChangeData>> fromSource = new HashMap<ChangeData, DataSource<ChangeData>>();

    public static QueryOptions oneResult() {
        return IndexedChangeQuery.createOptions(IndexConfig.createDefault(), 0, 1, ImmutableSet.of());
    }

    public static QueryOptions createOptions(IndexConfig config, int start, int limit, Set<String> fields) {
        if (!fields.contains(ChangeField.CHANGE.getName()) && !fields.contains(ChangeField.PROJECT.getName())) {
            fields = new HashSet<String>(fields);
            fields.add(ChangeField.PROJECT.getName());
        }
        return QueryOptions.create(config, start, limit, fields);
    }

    @VisibleForTesting
    static QueryOptions convertOptions(QueryOptions opts) {
        opts = opts.convertForBackend();
        return IndexedChangeQuery.createOptions(opts.config(), opts.start(), opts.limit(), opts.fields());
    }

    public IndexedChangeQuery(ChangeIndex index, Predicate<ChangeData> pred, QueryOptions opts) throws QueryParseException {
        super(index, pred, IndexedChangeQuery.convertOptions(opts));
    }

    @Override
    public ResultSet<ChangeData> read() throws OrmException {
        final DataSource currSource = this.source;
        final ResultSet rs = currSource.read();
        return new ResultSet<ChangeData>(){

            @Override
            public Iterator<ChangeData> iterator() {
                return Iterables.transform(rs, cd -> {
                    IndexedChangeQuery.this.fromSource.put(cd, currSource);
                    return cd;
                }).iterator();
            }

            @Override
            public List<ChangeData> toList() {
                List<ChangeData> r = rs.toList();
                for (ChangeData cd : r) {
                    IndexedChangeQuery.this.fromSource.put(cd, currSource);
                }
                return r;
            }

            @Override
            public void close() {
                rs.close();
            }
        };
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        if (this.source != null && this.fromSource.get(cd) == this.source) {
            return true;
        }
        Predicate pred = this.getChild(0);
        Preconditions.checkState(pred.isMatchable(), "match invoked, but child predicate %s doesn't implement %s", pred, (Object)Matchable.class.getName());
        return pred.asMatchable().match(cd);
    }

    @Override
    public int getCost() {
        return 1;
    }

    @Override
    public boolean hasChange() {
        return this.index.getSchema().hasField(ChangeField.CHANGE);
    }
}

