/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.common.io.CharStreams;
import com.google.common.io.Resources;
import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.shared.SoyAstCache;
import com.google.template.soy.tofu.SoyTofu;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Singleton
public class MailSoyTofuProvider
implements Provider<SoyTofu> {
    private static final String[] TEMPLATES = new String[]{"Abandoned.soy", "AbandonedHtml.soy", "AddKey.soy", "AddKeyHtml.soy", "ChangeFooter.soy", "ChangeFooterHtml.soy", "ChangeSubject.soy", "Comment.soy", "CommentHtml.soy", "CommentFooter.soy", "CommentFooterHtml.soy", "DeleteKey.soy", "DeleteKeyHtml.soy", "DeleteReviewer.soy", "DeleteReviewerHtml.soy", "DeleteVote.soy", "DeleteVoteHtml.soy", "Footer.soy", "FooterHtml.soy", "HeaderHtml.soy", "HttpPasswordUpdate.soy", "HttpPasswordUpdateHtml.soy", "Merged.soy", "MergedHtml.soy", "NewChange.soy", "NewChangeHtml.soy", "Private.soy", "RegisterNewEmail.soy", "ReplacePatchSet.soy", "ReplacePatchSetHtml.soy", "Restored.soy", "RestoredHtml.soy", "Reverted.soy", "RevertedHtml.soy", "SetAssignee.soy", "SetAssigneeHtml.soy"};
    private final SitePaths site;
    private final SoyAstCache cache;

    @Inject
    MailSoyTofuProvider(SitePaths site, SoyAstCache cache) {
        this.site = site;
        this.cache = cache;
    }

    @Override
    public SoyTofu get() throws ProvisionException {
        SoyFileSet.Builder builder = SoyFileSet.builder();
        builder.setSoyAstCache(this.cache);
        for (String name : TEMPLATES) {
            this.addTemplate(builder, name);
        }
        return builder.build().compileToTofu();
    }

    private void addTemplate(SoyFileSet.Builder builder, String name) throws ProvisionException {
        Path tmpl = this.site.mail_dir.resolve(name);
        if (Files.isRegularFile(tmpl, new LinkOption[0])) {
            String content;
            try (BufferedReader r = Files.newBufferedReader(tmpl, StandardCharsets.UTF_8);){
                content = CharStreams.toString(r);
            }
            catch (IOException err) {
                throw new ProvisionException("Failed to read template file " + tmpl.toAbsolutePath().toString(), err);
            }
            builder.add(content, tmpl.toAbsolutePath().toString());
            return;
        }
        String resourcePath = "com/google/gerrit/server/mail/" + name;
        builder.add(Resources.getResource(resourcePath));
    }
}

