/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.send.ChangeEmail;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class NewChangeSender
extends ChangeEmail {
    private final Set<Account.Id> reviewers = new HashSet<Account.Id>();
    private final Set<Address> reviewersByEmail = new HashSet<Address>();
    private final Set<Account.Id> extraCC = new HashSet<Account.Id>();
    private final Set<Address> extraCCByEmail = new HashSet<Address>();

    protected NewChangeSender(EmailArguments ea, ChangeData cd) throws OrmException {
        super(ea, "newchange", cd);
    }

    public void addReviewers(Collection<Account.Id> cc) {
        this.reviewers.addAll(cc);
    }

    public void addReviewersByEmail(Collection<Address> cc) {
        this.reviewersByEmail.addAll(cc);
    }

    public void addExtraCC(Collection<Account.Id> cc) {
        this.extraCC.addAll(cc);
    }

    public void addExtraCCByEmail(Collection<Address> cc) {
        this.extraCCByEmail.addAll(cc);
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        String threadId = this.getChangeMessageThreadId();
        this.setHeader("Message-ID", threadId);
        this.setHeader("References", threadId);
        switch (this.notify) {
            case NONE: 
            case OWNER: {
                break;
            }
            default: {
                this.add(RecipientType.CC, this.extraCC);
                this.extraCCByEmail.stream().forEach(cc -> this.add(RecipientType.CC, (Address)cc));
            }
            case OWNER_REVIEWERS: {
                this.add(RecipientType.TO, this.reviewers, true);
                this.addByEmail(RecipientType.TO, this.reviewersByEmail, true);
            }
        }
        this.rcptToAuthors(RecipientType.CC);
    }

    @Override
    protected void formatChange() throws EmailException {
        this.appendText(this.textTemplate("NewChange"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("NewChangeHtml"));
        }
    }

    public List<String> getReviewerNames() {
        if (this.reviewers.isEmpty()) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Account.Id id : this.reviewers) {
            names.add(this.getNameFor(id));
        }
        return names;
    }

    @Override
    protected void setupSoyContext() {
        super.setupSoyContext();
        this.soyContext.put("ownerName", this.getNameFor(this.change.getOwner()));
        this.soyContextEmailData.put("reviewerNames", this.getReviewerNames());
    }

    @Override
    protected boolean supportsHtml() {
        return true;
    }
}

