/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mime;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.mime.FileTypeRegistry;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil2;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MimeUtilFileTypeRegistry
implements FileTypeRegistry {
    private static final String KEY_SAFE = "safe";
    private static final String SECTION_MIMETYPE = "mimetype";
    private static final Logger log = LoggerFactory.getLogger(MimeUtilFileTypeRegistry.class);
    private final Config cfg;
    private final MimeUtil2 mimeUtil;

    @Inject
    MimeUtilFileTypeRegistry(@GerritServerConfig Config gsc, MimeUtil2 mu2) {
        this.cfg = gsc;
        this.mimeUtil = mu2;
    }

    private int getCorrectedMimeSpecificity(MimeType mimeType) {
        String mimeTypeStr = mimeType.toString();
        if (mimeTypeStr.equals("application/octet-stream")) {
            return -1;
        }
        if (mimeTypeStr.equals("text/plain")) {
            return 0;
        }
        return mimeType.getSpecificity();
    }

    @Override
    public MimeType getMimeType(String path, byte[] content) {
        HashSet<MimeType> mimeTypes = new HashSet<MimeType>();
        if (content != null && content.length > 0) {
            try {
                mimeTypes.addAll(this.mimeUtil.getMimeTypes(content));
            }
            catch (MimeException e) {
                log.warn("Unable to determine MIME type from content", e);
            }
        }
        return this.getMimeType(mimeTypes, path);
    }

    @Override
    public MimeType getMimeType(String path, InputStream is) {
        HashSet<MimeType> mimeTypes = new HashSet<MimeType>();
        try {
            mimeTypes.addAll(this.mimeUtil.getMimeTypes(is));
        }
        catch (MimeException e) {
            log.warn("Unable to determine MIME type from content", e);
        }
        return this.getMimeType(mimeTypes, path);
    }

    private MimeType getMimeType(Set<MimeType> mimeTypes, String path) {
        try {
            mimeTypes.addAll(this.mimeUtil.getMimeTypes(path));
        }
        catch (MimeException e) {
            log.warn("Unable to determine MIME type from path", e);
        }
        if (MimeUtilFileTypeRegistry.isUnknownType(mimeTypes)) {
            return MimeUtil2.UNKNOWN_MIME_TYPE;
        }
        ArrayList<MimeType> types = new ArrayList<MimeType>(mimeTypes);
        Collections.sort(types, new Comparator<MimeType>(){

            @Override
            public int compare(MimeType a, MimeType b) {
                return MimeUtilFileTypeRegistry.this.getCorrectedMimeSpecificity(b) - MimeUtilFileTypeRegistry.this.getCorrectedMimeSpecificity(a);
            }
        });
        return (MimeType)types.get(0);
    }

    @Override
    public boolean isSafeInline(MimeType type) {
        if (MimeUtil2.UNKNOWN_MIME_TYPE.equals(type)) {
            return false;
        }
        boolean any = MimeUtilFileTypeRegistry.isSafe(this.cfg, "*/*", false);
        boolean genericMedia = MimeUtilFileTypeRegistry.isSafe(this.cfg, type.getMediaType() + "/*", any);
        return MimeUtilFileTypeRegistry.isSafe(this.cfg, type.toString(), genericMedia);
    }

    private static boolean isSafe(Config cfg, String type, boolean def) {
        return cfg.getBoolean(SECTION_MIMETYPE, type, KEY_SAFE, def);
    }

    private static boolean isUnknownType(Collection<MimeType> mimeTypes) {
        if (mimeTypes.isEmpty()) {
            return true;
        }
        return mimeTypes.size() == 1 && mimeTypes.contains(MimeUtil2.UNKNOWN_MIME_TYPE);
    }
}

