/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.InternalUser;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public abstract class AbstractChangeUpdate {
    protected final NotesMigration migration;
    protected final ChangeNoteUtil noteUtil;
    protected final String anonymousCowardName;
    protected final Account.Id accountId;
    protected final Account.Id realAccountId;
    protected final PersonIdent authorIdent;
    protected final Date when;
    private final long readOnlySkewMs;
    @Nullable
    private final ChangeNotes notes;
    private final Change change;
    protected final PersonIdent serverIdent;
    protected PatchSet.Id psId;
    private ObjectId result;
    protected boolean rootOnly;
    protected static final CommitBuilder NO_OP_UPDATE = new CommitBuilder();

    protected AbstractChangeUpdate(Config cfg, NotesMigration migration, ChangeNotes notes, CurrentUser user, PersonIdent serverIdent, String anonymousCowardName, ChangeNoteUtil noteUtil, Date when) {
        this.migration = migration;
        this.noteUtil = noteUtil;
        this.serverIdent = new PersonIdent(serverIdent, when);
        this.anonymousCowardName = anonymousCowardName;
        this.notes = notes;
        this.change = notes.getChange();
        this.accountId = AbstractChangeUpdate.accountId(user);
        Account.Id realAccountId = AbstractChangeUpdate.accountId(user.getRealUser());
        this.realAccountId = realAccountId != null ? realAccountId : this.accountId;
        this.authorIdent = AbstractChangeUpdate.ident(noteUtil, serverIdent, anonymousCowardName, user, when);
        this.when = when;
        this.readOnlySkewMs = NoteDbChangeState.getReadOnlySkew(cfg);
    }

    protected AbstractChangeUpdate(Config cfg, NotesMigration migration, ChangeNoteUtil noteUtil, PersonIdent serverIdent, String anonymousCowardName, @Nullable ChangeNotes notes, @Nullable Change change, Account.Id accountId, Account.Id realAccountId, PersonIdent authorIdent, Date when) {
        Preconditions.checkArgument(notes != null && change == null || notes == null && change != null, "exactly one of notes or change required");
        this.migration = migration;
        this.noteUtil = noteUtil;
        this.serverIdent = new PersonIdent(serverIdent, when);
        this.anonymousCowardName = anonymousCowardName;
        this.notes = notes;
        this.change = change != null ? change : notes.getChange();
        this.accountId = accountId;
        this.realAccountId = realAccountId;
        this.authorIdent = authorIdent;
        this.when = when;
        this.readOnlySkewMs = NoteDbChangeState.getReadOnlySkew(cfg);
    }

    private static void checkUserType(CurrentUser user) {
        Preconditions.checkArgument(user instanceof IdentifiedUser || user instanceof InternalUser, "user must be IdentifiedUser or InternalUser: %s", (Object)user);
    }

    private static Account.Id accountId(CurrentUser u) {
        AbstractChangeUpdate.checkUserType(u);
        return u instanceof IdentifiedUser ? u.getAccountId() : null;
    }

    private static PersonIdent ident(ChangeNoteUtil noteUtil, PersonIdent serverIdent, String anonymousCowardName, CurrentUser u, Date when) {
        AbstractChangeUpdate.checkUserType(u);
        if (u instanceof IdentifiedUser) {
            return noteUtil.newIdent(u.asIdentifiedUser().getAccount(), when, serverIdent, anonymousCowardName);
        }
        if (u instanceof InternalUser) {
            return serverIdent;
        }
        throw new IllegalStateException();
    }

    public Change.Id getId() {
        return this.change.getId();
    }

    @Nullable
    public ChangeNotes getNotes() {
        return this.notes;
    }

    public Change getChange() {
        return this.change;
    }

    public Date getWhen() {
        return this.when;
    }

    public PatchSet.Id getPatchSetId() {
        return this.psId;
    }

    public void setPatchSetId(PatchSet.Id psId) {
        Preconditions.checkArgument(psId == null || psId.getParentKey().equals(this.getId()));
        this.psId = psId;
    }

    public Account.Id getAccountId() {
        Preconditions.checkState(this.accountId != null, "author identity for %s is not from an IdentifiedUser: %s", (Object)this.getClass().getSimpleName(), (Object)this.authorIdent.toExternalString());
        return this.accountId;
    }

    public Account.Id getNullableAccountId() {
        return this.accountId;
    }

    protected PersonIdent newIdent(Account author, Date when) {
        return this.noteUtil.newIdent(author, when, this.serverIdent, this.anonymousCowardName);
    }

    public abstract boolean isEmpty();

    public boolean isRootOnly() {
        return this.rootOnly;
    }

    protected abstract Project.NameKey getProjectName();

    protected abstract String getRefName();

    final ObjectId apply(RevWalk rw, ObjectInserter ins, ObjectId curr) throws OrmException, IOException {
        if (this.isEmpty()) {
            return null;
        }
        Preconditions.checkArgument(rw.getObjectReader().getCreatedFromInserter() == ins);
        this.checkNotReadOnly();
        ObjectId z = ObjectId.zeroId();
        CommitBuilder cb = this.applyImpl(rw, ins, curr);
        if (cb == null) {
            this.result = z;
            return z;
        }
        if (cb == NO_OP_UPDATE) {
            return null;
        }
        cb.setAuthor(this.authorIdent);
        cb.setCommitter(new PersonIdent(this.serverIdent, this.when));
        if (!curr.equals(z)) {
            cb.setParentId(curr);
        } else {
            cb.setParentIds(new ObjectId[0]);
        }
        if (cb.getTreeId() == null) {
            if (curr.equals(z)) {
                cb.setTreeId(AbstractChangeUpdate.emptyTree(ins));
            } else {
                RevCommit p = rw.parseCommit(curr);
                cb.setTreeId(p.getTree());
            }
        }
        this.result = ins.insert(cb);
        return this.result;
    }

    protected void checkNotReadOnly() throws OrmException {
        ChangeNotes notes = this.getNotes();
        if (notes == null) {
            return;
        }
        Timestamp until = notes.getReadOnlyUntil();
        if (until != null && NoteDbChangeState.timeForReadOnlyCheck(this.readOnlySkewMs).before(until)) {
            throw new OrmException("change " + notes.getChangeId() + " is read-only until " + until);
        }
    }

    protected abstract CommitBuilder applyImpl(RevWalk var1, ObjectInserter var2, ObjectId var3) throws OrmException, IOException;

    ObjectId getResult() {
        return this.result;
    }

    public boolean allowWriteToNewRef() {
        return true;
    }

    private static ObjectId emptyTree(ObjectInserter ins) throws IOException {
        return ins.insert(2, new byte[0]);
    }

    protected void verifyComment(Comment c) {
        Preconditions.checkArgument(c.revId != null, "RevId required for comment: %s", (Object)c);
        Preconditions.checkArgument(c.author.getId().equals(this.getAccountId()), "The author for the following comment does not match the author of this %s (%s): %s", (Object)this.getClass().getSimpleName(), (Object)this.getAccountId(), (Object)c);
        Preconditions.checkArgument(c.getRealAuthor().getId().equals(this.realAccountId), "The real author for the following comment does not match the real author of this %s (%s): %s", (Object)this.getClass().getSimpleName(), (Object)this.realAccountId, (Object)c);
    }
}

