/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.client.RobotComment;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.notedb.AbstractChangeUpdate;
import com.google.gerrit.server.notedb.ChangeDraftUpdate;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeRevisionNote;
import com.google.gerrit.server.notedb.DeleteCommentRewriter;
import com.google.gerrit.server.notedb.NoteDbUpdateManager;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.PatchSetState;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.notedb.RevisionNoteBuilder;
import com.google.gerrit.server.notedb.RevisionNoteMap;
import com.google.gerrit.server.notedb.RobotCommentUpdate;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.util.LabelVote;
import com.google.gerrit.server.util.RequestId;
import com.google.gwtorm.client.IntKey;
import com.google.gwtorm.server.OrmException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.FooterKey;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ChangeUpdate
extends AbstractChangeUpdate {
    private final AccountCache accountCache;
    private final NoteDbUpdateManager.Factory updateManagerFactory;
    private final ChangeDraftUpdate.Factory draftUpdateFactory;
    private final RobotCommentUpdate.Factory robotCommentUpdateFactory;
    private final DeleteCommentRewriter.Factory deleteCommentRewriterFactory;
    private final Table<String, Account.Id, Optional<Short>> approvals;
    private final Map<Account.Id, ReviewerStateInternal> reviewers = new LinkedHashMap<Account.Id, ReviewerStateInternal>();
    private final Map<Address, ReviewerStateInternal> reviewersByEmail = new LinkedHashMap<Address, ReviewerStateInternal>();
    private final List<Comment> comments = new ArrayList<Comment>();
    private String commitSubject;
    private String subject;
    private String changeId;
    private String branch;
    private Change.Status status;
    private List<SubmitRecord> submitRecords;
    private String submissionId;
    private String topic;
    private String commit;
    private Optional<Account.Id> assignee;
    private Set<String> hashtags;
    private String changeMessage;
    private String tag;
    private PatchSetState psState;
    private Iterable<String> groups;
    private String pushCert;
    private boolean isAllowWriteToNewtRef;
    private String psDescription;
    private boolean currentPatchSet;
    private Timestamp readOnlyUntil;
    private Boolean isPrivate;
    private Boolean workInProgress;
    private Integer revertOf;
    private ChangeDraftUpdate draftUpdate;
    private RobotCommentUpdate robotCommentUpdate;
    private DeleteCommentRewriter deleteCommentRewriter;

    @AssistedInject
    private ChangeUpdate(@GerritServerConfig Config cfg, @GerritPersonIdent PersonIdent serverIdent, @AnonymousCowardName String anonymousCowardName, NotesMigration migration, AccountCache accountCache, NoteDbUpdateManager.Factory updateManagerFactory, ChangeDraftUpdate.Factory draftUpdateFactory, RobotCommentUpdate.Factory robotCommentUpdateFactory, DeleteCommentRewriter.Factory deleteCommentRewriterFactory, ProjectCache projectCache, @Assisted ChangeNotes notes, @Assisted CurrentUser user, ChangeNoteUtil noteUtil) {
        this(cfg, serverIdent, anonymousCowardName, migration, accountCache, updateManagerFactory, draftUpdateFactory, robotCommentUpdateFactory, deleteCommentRewriterFactory, projectCache, notes, user, serverIdent.getWhen(), noteUtil);
    }

    @AssistedInject
    private ChangeUpdate(@GerritServerConfig Config cfg, @GerritPersonIdent PersonIdent serverIdent, @AnonymousCowardName String anonymousCowardName, NotesMigration migration, AccountCache accountCache, NoteDbUpdateManager.Factory updateManagerFactory, ChangeDraftUpdate.Factory draftUpdateFactory, RobotCommentUpdate.Factory robotCommentUpdateFactory, DeleteCommentRewriter.Factory deleteCommentRewriterFactory, ProjectCache projectCache, @Assisted ChangeNotes notes, @Assisted CurrentUser user, @Assisted Date when, ChangeNoteUtil noteUtil) {
        this(cfg, serverIdent, anonymousCowardName, migration, accountCache, updateManagerFactory, draftUpdateFactory, robotCommentUpdateFactory, deleteCommentRewriterFactory, notes, user, when, projectCache.get(notes.getProjectName()).getLabelTypes().nameComparator(), noteUtil);
    }

    private static Table<String, Account.Id, Optional<Short>> approvals(Comparator<String> nameComparator) {
        return TreeBasedTable.create(nameComparator, Comparator.comparing(IntKey::get));
    }

    @AssistedInject
    private ChangeUpdate(@GerritServerConfig Config cfg, @GerritPersonIdent PersonIdent serverIdent, @AnonymousCowardName String anonymousCowardName, NotesMigration migration, AccountCache accountCache, NoteDbUpdateManager.Factory updateManagerFactory, ChangeDraftUpdate.Factory draftUpdateFactory, RobotCommentUpdate.Factory robotCommentUpdateFactory, DeleteCommentRewriter.Factory deleteCommentRewriterFactory, @Assisted ChangeNotes notes, @Assisted CurrentUser user, @Assisted Date when, @Assisted Comparator<String> labelNameComparator, ChangeNoteUtil noteUtil) {
        super(cfg, migration, notes, user, serverIdent, anonymousCowardName, noteUtil, when);
        this.accountCache = accountCache;
        this.updateManagerFactory = updateManagerFactory;
        this.draftUpdateFactory = draftUpdateFactory;
        this.robotCommentUpdateFactory = robotCommentUpdateFactory;
        this.deleteCommentRewriterFactory = deleteCommentRewriterFactory;
        this.approvals = ChangeUpdate.approvals(labelNameComparator);
    }

    @AssistedInject
    private ChangeUpdate(@GerritServerConfig Config cfg, @GerritPersonIdent PersonIdent serverIdent, @AnonymousCowardName String anonymousCowardName, NotesMigration migration, AccountCache accountCache, NoteDbUpdateManager.Factory updateManagerFactory, ChangeDraftUpdate.Factory draftUpdateFactory, RobotCommentUpdate.Factory robotCommentUpdateFactory, DeleteCommentRewriter.Factory deleteCommentRewriterFactory, ChangeNoteUtil noteUtil, @Assisted Change change, @Assisted(value="effective") @Nullable Account.Id accountId, @Assisted(value="real") @Nullable Account.Id realAccountId, @Assisted PersonIdent authorIdent, @Assisted Date when, @Assisted Comparator<String> labelNameComparator) {
        super(cfg, migration, noteUtil, serverIdent, anonymousCowardName, null, change, accountId, realAccountId, authorIdent, when);
        this.accountCache = accountCache;
        this.draftUpdateFactory = draftUpdateFactory;
        this.robotCommentUpdateFactory = robotCommentUpdateFactory;
        this.updateManagerFactory = updateManagerFactory;
        this.deleteCommentRewriterFactory = deleteCommentRewriterFactory;
        this.approvals = ChangeUpdate.approvals(labelNameComparator);
    }

    public ObjectId commit() throws IOException, OrmException {
        try (NoteDbUpdateManager updateManager = this.updateManagerFactory.create(this.getProjectName());){
            updateManager.add(this);
            updateManager.stageAndApplyDelta(this.getChange());
            updateManager.execute();
        }
        return this.getResult();
    }

    public void setChangeId(String changeId) {
        String old = this.getChange().getKey().get();
        Preconditions.checkArgument(old.equals(changeId), "The Change-Id was already set to %s, so we cannot set this Change-Id: %s", (Object)old, (Object)changeId);
        this.changeId = changeId;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setStatus(Change.Status status) {
        Preconditions.checkArgument(status != Change.Status.MERGED, "use merge(Iterable<SubmitRecord>)");
        this.status = status;
    }

    public void fixStatus(Change.Status status) {
        this.status = status;
    }

    public void putApproval(String label, short value) {
        this.putApprovalFor(this.getAccountId(), label, value);
    }

    public void putApprovalFor(Account.Id reviewer, String label, short value) {
        this.approvals.put(label, reviewer, Optional.of(value));
    }

    public void removeApproval(String label) {
        this.removeApprovalFor(this.getAccountId(), label);
    }

    public void removeApprovalFor(Account.Id reviewer, String label) {
        this.approvals.put(label, reviewer, Optional.empty());
    }

    public void merge(RequestId submissionId, Iterable<SubmitRecord> submitRecords) {
        this.status = Change.Status.MERGED;
        this.submissionId = submissionId.toStringForStorage();
        this.submitRecords = ImmutableList.copyOf(submitRecords);
        Preconditions.checkArgument(!this.submitRecords.isEmpty(), "no submit records specified at submit time");
    }

    @Deprecated
    public void setSubmissionId(String submissionId) {
        this.submissionId = submissionId;
    }

    public void setSubjectForCommit(String commitSubject) {
        this.commitSubject = commitSubject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @VisibleForTesting
    ObjectId getCommit() {
        return ObjectId.fromString(this.commit);
    }

    public void setChangeMessage(String changeMessage) {
        this.changeMessage = changeMessage;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setPsDescription(String psDescription) {
        this.psDescription = psDescription;
    }

    public void putComment(PatchLineComment.Status status, Comment c) {
        this.verifyComment(c);
        this.createDraftUpdateIfNull();
        if (status == PatchLineComment.Status.DRAFT) {
            this.draftUpdate.putComment(c);
        } else {
            this.comments.add(c);
            this.draftUpdate.deleteComment(c);
        }
    }

    public void putRobotComment(RobotComment c) {
        this.verifyComment(c);
        this.createRobotCommentUpdateIfNull();
        this.robotCommentUpdate.putComment(c);
    }

    public void deleteComment(Comment c) {
        this.verifyComment(c);
        this.createDraftUpdateIfNull().deleteComment(c);
    }

    public void deleteCommentByRewritingHistory(String uuid, String newMessage) {
        this.deleteCommentRewriter = this.deleteCommentRewriterFactory.create(this.getChange().getId(), uuid, newMessage);
    }

    @VisibleForTesting
    ChangeDraftUpdate createDraftUpdateIfNull() {
        if (this.draftUpdate == null) {
            ChangeNotes notes = this.getNotes();
            this.draftUpdate = notes != null ? this.draftUpdateFactory.create(notes, this.accountId, this.realAccountId, this.authorIdent, this.when) : this.draftUpdateFactory.create(this.getChange(), this.accountId, this.realAccountId, this.authorIdent, this.when);
        }
        return this.draftUpdate;
    }

    @VisibleForTesting
    RobotCommentUpdate createRobotCommentUpdateIfNull() {
        if (this.robotCommentUpdate == null) {
            ChangeNotes notes = this.getNotes();
            this.robotCommentUpdate = notes != null ? this.robotCommentUpdateFactory.create(notes, this.accountId, this.realAccountId, this.authorIdent, this.when) : this.robotCommentUpdateFactory.create(this.getChange(), this.accountId, this.realAccountId, this.authorIdent, this.when);
        }
        return this.robotCommentUpdate;
    }

    public void setTopic(String topic) {
        this.topic = Strings.nullToEmpty(topic);
    }

    public void setCommit(RevWalk rw, ObjectId id) throws IOException {
        this.setCommit(rw, id, null);
    }

    public void setCommit(RevWalk rw, ObjectId id, String pushCert) throws IOException {
        RevCommit commit = rw.parseCommit(id);
        rw.parseBody(commit);
        this.commit = commit.name();
        this.subject = commit.getShortMessage();
        this.pushCert = pushCert;
    }

    public void setRevisionForMissingCommit(String id, String pushCert) {
        this.commit = id;
        this.pushCert = pushCert;
    }

    public void setHashtags(Set<String> hashtags) {
        this.hashtags = hashtags;
    }

    public void setAssignee(Account.Id assignee) {
        Preconditions.checkArgument(assignee != null, "use removeAssignee");
        this.assignee = Optional.of(assignee);
    }

    public void removeAssignee() {
        this.assignee = Optional.empty();
    }

    public Map<Account.Id, ReviewerStateInternal> getReviewers() {
        return this.reviewers;
    }

    public void putReviewer(Account.Id reviewer, ReviewerStateInternal type) {
        Preconditions.checkArgument(type != ReviewerStateInternal.REMOVED, "invalid ReviewerType");
        this.reviewers.put(reviewer, type);
    }

    public void removeReviewer(Account.Id reviewer) {
        this.reviewers.put(reviewer, ReviewerStateInternal.REMOVED);
    }

    public void putReviewerByEmail(Address reviewer, ReviewerStateInternal type) {
        Preconditions.checkArgument(type != ReviewerStateInternal.REMOVED, "invalid ReviewerType");
        this.reviewersByEmail.put(reviewer, type);
    }

    public void removeReviewerByEmail(Address reviewer) {
        this.reviewersByEmail.put(reviewer, ReviewerStateInternal.REMOVED);
    }

    public void setPatchSetState(PatchSetState psState) {
        this.psState = psState;
    }

    public void setCurrentPatchSet() {
        this.currentPatchSet = true;
    }

    public void setGroups(List<String> groups) {
        Preconditions.checkNotNull(groups, "groups may not be null");
        this.groups = groups;
    }

    public void setRevertOf(int revertOf) {
        int ownId = this.getChange().getId().get();
        Preconditions.checkArgument(ownId != revertOf, "A change cannot revert itself");
        this.revertOf = revertOf;
        this.rootOnly = true;
    }

    private ObjectId storeRevisionNotes(RevWalk rw, ObjectInserter inserter, ObjectId curr) throws ConfigInvalidException, OrmException, IOException {
        if (this.comments.isEmpty() && this.pushCert == null) {
            return null;
        }
        RevisionNoteMap<ChangeRevisionNote> rnm = this.getRevisionNoteMap(rw, curr);
        RevisionNoteBuilder.Cache cache = new RevisionNoteBuilder.Cache(rnm);
        for (Comment c : this.comments) {
            c.tag = this.tag;
            cache.get(new RevId(c.revId)).putComment(c);
        }
        if (this.pushCert != null) {
            Preconditions.checkState(this.commit != null);
            cache.get(new RevId(this.commit)).setPushCertificate(this.pushCert);
        }
        Map<RevId, RevisionNoteBuilder> builders = cache.getBuilders();
        this.checkComments(rnm.revisionNotes, builders);
        for (Map.Entry<RevId, RevisionNoteBuilder> e : builders.entrySet()) {
            ObjectId data = inserter.insert(3, e.getValue().build(this.noteUtil, this.noteUtil.getWriteJson()));
            rnm.noteMap.set(ObjectId.fromString(e.getKey().get()), data);
        }
        return rnm.noteMap.writeTree(inserter);
    }

    private RevisionNoteMap<ChangeRevisionNote> getRevisionNoteMap(RevWalk rw, ObjectId curr) throws ConfigInvalidException, OrmException, IOException {
        ObjectId idFromNotes;
        ChangeNotes notes;
        if (curr.equals(ObjectId.zeroId())) {
            return RevisionNoteMap.emptyMap();
        }
        if (this.migration.readChanges() && (notes = this.getNotes()) != null && notes.revisionNoteMap != null && (idFromNotes = MoreObjects.firstNonNull(((ChangeNotes)notes.load()).getRevision(), ObjectId.zeroId())).equals(curr)) {
            return notes.revisionNoteMap;
        }
        NoteMap noteMap = NoteMap.read(rw.getObjectReader(), rw.parseCommit(curr));
        return RevisionNoteMap.parse(this.noteUtil, this.getId(), rw.getObjectReader(), noteMap, PatchLineComment.Status.PUBLISHED);
    }

    private void checkComments(Map<RevId, ChangeRevisionNote> existingNotes, Map<RevId, RevisionNoteBuilder> toUpdate) throws OrmException {
        HashSet<Comment.Key> existing = new HashSet<Comment.Key>();
        for (ChangeRevisionNote rn : existingNotes.values()) {
            for (Comment c : rn.getComments()) {
                existing.add(c.key);
                if (this.draftUpdate == null) continue;
                this.draftUpdate.deleteComment(c.revId, c.key);
            }
        }
        for (RevisionNoteBuilder b : toUpdate.values()) {
            for (Comment c : b.put.values()) {
                if (!existing.contains(c.key)) continue;
                throw new OrmException("Cannot update existing published comment: " + c);
            }
        }
    }

    @Override
    protected String getRefName() {
        return RefNames.changeMetaRef(this.getId());
    }

    @Override
    protected CommitBuilder applyImpl(RevWalk rw, ObjectInserter ins, ObjectId curr) throws OrmException, IOException {
        Preconditions.checkState(this.deleteCommentRewriter == null, "cannot update and rewrite ref in one BatchUpdate");
        CommitBuilder cb = new CommitBuilder();
        int ps = this.psId != null ? this.psId.get() : this.getChange().currentPatchSetId().get();
        StringBuilder msg = new StringBuilder();
        if (this.commitSubject != null) {
            msg.append(this.commitSubject);
        } else {
            msg.append("Update patch set ").append(ps);
        }
        msg.append("\n\n");
        if (this.changeMessage != null) {
            msg.append(this.changeMessage);
            msg.append("\n\n");
        }
        this.addPatchSetFooter(msg, ps);
        if (this.currentPatchSet) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_CURRENT, Boolean.TRUE);
        }
        if (this.psDescription != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_PATCH_SET_DESCRIPTION, this.psDescription);
        }
        if (this.changeId != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_CHANGE_ID, this.changeId);
        }
        if (this.subject != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_SUBJECT, this.subject);
        }
        if (this.branch != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_BRANCH, this.branch);
        }
        if (this.status != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_STATUS, this.status.name().toLowerCase());
        }
        if (this.topic != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_TOPIC, this.topic);
        }
        if (this.commit != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_COMMIT, this.commit);
        }
        if (this.assignee != null) {
            if (this.assignee.isPresent()) {
                ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_ASSIGNEE);
                this.addIdent(msg, this.assignee.get()).append('\n');
            } else {
                ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_ASSIGNEE).append('\n');
            }
        }
        Joiner comma = Joiner.on(',');
        if (this.hashtags != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_HASHTAGS, comma.join(this.hashtags));
        }
        if (this.tag != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_TAG, this.tag);
        }
        if (this.groups != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_GROUPS, comma.join(this.groups));
        }
        for (Map.Entry<Account.Id, ReviewerStateInternal> entry : this.reviewers.entrySet()) {
            ChangeUpdate.addFooter(msg, entry.getValue().getFooterKey());
            this.addIdent(msg, entry.getKey()).append('\n');
        }
        for (Map.Entry<Object, ReviewerStateInternal> entry : this.reviewersByEmail.entrySet()) {
            ChangeUpdate.addFooter(msg, entry.getValue().getByEmailFooterKey(), ((Address)entry.getKey()).toString());
        }
        for (Table.Cell cell : this.approvals.cellSet()) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_LABEL);
            if (!((Optional)cell.getValue()).isPresent()) {
                msg.append('-').append((String)cell.getRowKey());
            } else {
                msg.append(LabelVote.create((String)cell.getRowKey(), (Short)((Optional)cell.getValue()).get()).formatWithEquals());
            }
            Account.Id id = (Account.Id)cell.getColumnKey();
            if (!id.equals(this.getAccountId())) {
                this.addIdent(msg.append(' '), id);
            }
            msg.append('\n');
        }
        if (this.submissionId != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_SUBMISSION_ID, this.submissionId);
        }
        if (this.submitRecords != null) {
            for (SubmitRecord submitRecord : this.submitRecords) {
                ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_SUBMITTED_WITH).append((Object)submitRecord.status);
                if (submitRecord.errorMessage != null) {
                    msg.append(' ').append(ChangeNoteUtil.sanitizeFooter(submitRecord.errorMessage));
                }
                msg.append('\n');
                if (submitRecord.labels == null) continue;
                for (SubmitRecord.Label label : submitRecord.labels) {
                    ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_SUBMITTED_WITH).append((Object)label.status).append(": ").append(label.label);
                    if (label.appliedBy != null) {
                        msg.append(": ");
                        this.addIdent(msg, label.appliedBy);
                    }
                    msg.append('\n');
                }
            }
        }
        if (!Objects.equals(this.accountId, this.realAccountId)) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_REAL_USER);
            this.addIdent(msg, this.realAccountId).append('\n');
        }
        if (this.readOnlyUntil != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_READ_ONLY_UNTIL, ChangeNoteUtil.formatTime(this.serverIdent, this.readOnlyUntil));
        }
        if (this.isPrivate != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_PRIVATE, this.isPrivate);
        }
        if (this.workInProgress != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_WORK_IN_PROGRESS, this.workInProgress);
        }
        if (this.revertOf != null) {
            ChangeUpdate.addFooter(msg, ChangeNoteUtil.FOOTER_REVERT_OF, this.revertOf);
        }
        cb.setMessage(msg.toString());
        try {
            ObjectId treeId = this.storeRevisionNotes(rw, ins, curr);
            if (treeId != null) {
                cb.setTreeId(treeId);
            }
        }
        catch (ConfigInvalidException e) {
            throw new OrmException(e);
        }
        return cb;
    }

    private void addPatchSetFooter(StringBuilder sb, int ps) {
        ChangeUpdate.addFooter(sb, ChangeNoteUtil.FOOTER_PATCH_SET).append(ps);
        if (this.psState != null) {
            sb.append(" (").append(this.psState.name().toLowerCase()).append(')');
        }
        sb.append('\n');
    }

    @Override
    protected Project.NameKey getProjectName() {
        return this.getChange().getProject();
    }

    @Override
    public boolean isEmpty() {
        return this.commitSubject == null && this.approvals.isEmpty() && this.changeMessage == null && this.comments.isEmpty() && this.reviewers.isEmpty() && this.reviewersByEmail.isEmpty() && this.changeId == null && this.branch == null && this.status == null && this.submissionId == null && this.submitRecords == null && this.assignee == null && this.hashtags == null && this.topic == null && this.commit == null && this.psState == null && this.groups == null && this.tag == null && this.psDescription == null && !this.currentPatchSet && this.readOnlyUntil == null && this.isPrivate == null && this.workInProgress == null && this.revertOf == null;
    }

    ChangeDraftUpdate getDraftUpdate() {
        return this.draftUpdate;
    }

    RobotCommentUpdate getRobotCommentUpdate() {
        return this.robotCommentUpdate;
    }

    public DeleteCommentRewriter getDeleteCommentRewriter() {
        return this.deleteCommentRewriter;
    }

    public void setAllowWriteToNewRef(boolean allow) {
        this.isAllowWriteToNewtRef = allow;
    }

    @Override
    public boolean allowWriteToNewRef() {
        return this.isAllowWriteToNewtRef;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public void setWorkInProgress(boolean workInProgress) {
        this.workInProgress = workInProgress;
    }

    void setReadOnlyUntil(Timestamp readOnlyUntil) {
        this.readOnlyUntil = readOnlyUntil;
    }

    private static StringBuilder addFooter(StringBuilder sb, FooterKey footer) {
        return sb.append(footer.getName()).append(": ");
    }

    private static void addFooter(StringBuilder sb, FooterKey footer, Object ... values) {
        ChangeUpdate.addFooter(sb, footer);
        for (Object value : values) {
            sb.append(ChangeNoteUtil.sanitizeFooter(Objects.toString(value)));
        }
        sb.append('\n');
    }

    private StringBuilder addIdent(StringBuilder sb, Account.Id accountId) {
        Account account = this.accountCache.get(accountId).getAccount();
        PersonIdent ident = this.newIdent(account, this.when);
        PersonIdent.appendSanitized(sb, ident.getName());
        sb.append(" <");
        PersonIdent.appendSanitized(sb, ident.getEmailAddress());
        sb.append('>');
        return sb;
    }

    @Override
    protected void checkNotReadOnly() throws OrmException {
        if (this.readOnlyUntil != null && this.readOnlyUntil.getTime() == 0L) {
            return;
        }
        super.checkNotReadOnly();
    }

    public static interface Factory {
        public ChangeUpdate create(ChangeNotes var1, CurrentUser var2);

        public ChangeUpdate create(ChangeNotes var1, CurrentUser var2, Date var3);

        public ChangeUpdate create(Change var1, @Assisted(value="effective") @Nullable Account.Id var2, @Assisted(value="real") @Nullable Account.Id var3, PersonIdent var4, Date var5, Comparator<String> var6);

        @VisibleForTesting
        public ChangeUpdate create(ChangeNotes var1, CurrentUser var2, Date var3, Comparator<String> var4);
    }
}

