/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.InMemoryInserter;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.ThreeWayMergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoMerger {
    private static final Logger log = LoggerFactory.getLogger(AutoMerger.class);
    private final PersonIdent gerritIdent;
    private final boolean save;

    public static boolean cacheAutomerge(Config cfg) {
        return cfg.getBoolean("change", null, "cacheAutomerge", true);
    }

    @Inject
    AutoMerger(@GerritServerConfig Config cfg, @GerritPersonIdent PersonIdent gerritIdent) {
        this.save = AutoMerger.cacheAutomerge(cfg);
        this.gerritIdent = gerritIdent;
    }

    public RevCommit merge(Repository repo, RevWalk rw, ObjectInserter ins, RevCommit merge, ThreeWayMergeStrategy mergeStrategy) throws IOException {
        ObjectId treeId;
        boolean couldMerge;
        Preconditions.checkArgument(rw.getObjectReader().getCreatedFromInserter() == ins);
        InMemoryInserter tmpIns = null;
        if (ins instanceof InMemoryInserter) {
            tmpIns = (InMemoryInserter)ins;
        } else if (!this.save) {
            tmpIns = new InMemoryInserter(rw.getObjectReader());
        }
        rw.parseHeaders(merge);
        String refName = RefNames.refsCacheAutomerge(merge.name());
        Ref ref = repo.getRefDatabase().exactRef(refName);
        if (ref != null && ref.getObjectId() != null) {
            RevObject obj = rw.parseAny(ref.getObjectId());
            if (obj instanceof RevCommit) {
                return (RevCommit)obj;
            }
            return this.commit(repo, rw, tmpIns, ins, refName, obj, merge);
        }
        ResolveMerger m = (ResolveMerger)mergeStrategy.newMerger(repo, true);
        DirCache dc = DirCache.newInCore();
        m.setDirCache(dc);
        m.setObjectInserter(tmpIns == null ? new NonFlushingWrapper(ins) : tmpIns);
        try {
            couldMerge = m.merge(merge.getParents());
        }
        catch (IOException e) {
            log.warn("Error attempting automerge " + refName, e);
            return null;
        }
        if (couldMerge) {
            treeId = m.getResultTreeId();
        } else {
            RevCommit ours = merge.getParent(0);
            RevCommit theirs = merge.getParent(1);
            rw.parseBody(ours);
            rw.parseBody(theirs);
            String oursMsg = ours.getShortMessage();
            String theirsMsg = theirs.getShortMessage();
            String oursName = String.format("HEAD   (%s %s)", ours.abbreviate(6).name(), oursMsg.substring(0, Math.min(oursMsg.length(), 60)));
            String theirsName = String.format("BRANCH (%s %s)", theirs.abbreviate(6).name(), theirsMsg.substring(0, Math.min(theirsMsg.length(), 60)));
            MergeFormatter fmt = new MergeFormatter();
            Map<String, MergeResult<? extends Sequence>> r = m.getMergeResults();
            HashMap<String, ObjectId> resolved = new HashMap<String, ObjectId>();
            for (Map.Entry<String, MergeResult<? extends Sequence>> entry : r.entrySet()) {
                MergeResult<? extends Sequence> p = entry.getValue();
                try (TemporaryBuffer.LocalFile buf = new TemporaryBuffer.LocalFile(null, 0xA00000);){
                    fmt.formatMerge(buf, p, "BASE", oursName, theirsName, StandardCharsets.UTF_8.name());
                    buf.close();
                    InputStream in = ((TemporaryBuffer)buf).openInputStream();
                    try {
                        resolved.put(entry.getKey(), ins.insert(3, ((TemporaryBuffer)buf).length(), in));
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
            }
            DirCacheBuilder builder = dc.builder();
            int cnt = dc.getEntryCount();
            int i = 0;
            while (i < cnt) {
                DirCacheEntry entry = dc.getEntry(i);
                if (entry.getStage() == 0) {
                    builder.add(entry);
                    ++i;
                    continue;
                }
                int next = dc.nextEntry(i);
                String path = entry.getPathString();
                DirCacheEntry res = new DirCacheEntry(path);
                if (resolved.containsKey(path)) {
                    res.setFileMode(entry.getFileMode());
                    res.setObjectId((AnyObjectId)resolved.get(path));
                } else if (next == i + 1) {
                    res.setFileMode(entry.getFileMode());
                    res.setObjectId(entry.getObjectId());
                } else if (next == i + 2) {
                    entry = dc.getEntry(i + 1);
                    res.setFileMode(entry.getFileMode());
                    res.setObjectId(entry.getObjectId());
                } else {
                    res.setFileMode(entry.getFileMode());
                    res.setObjectId(entry.getObjectId());
                }
                builder.add(res);
                i = next;
            }
            builder.finish();
            treeId = dc.writeTree(ins);
        }
        return this.commit(repo, rw, tmpIns, ins, refName, treeId, merge);
    }

    private RevCommit commit(Repository repo, RevWalk rw, @Nullable InMemoryInserter tmpIns, ObjectInserter ins, String refName, ObjectId tree, RevCommit merge) throws IOException {
        rw.parseHeaders(merge);
        PersonIdent ident = new PersonIdent(this.gerritIdent, merge.getCommitterIdent().getWhen(), this.gerritIdent.getTimeZone());
        CommitBuilder cb = new CommitBuilder();
        cb.setAuthor(ident);
        cb.setCommitter(ident);
        cb.setTreeId(tree);
        cb.setMessage("Auto-merge of " + merge.name() + '\n');
        for (RevCommit p : merge.getParents()) {
            cb.addParentId(p);
        }
        if (!this.save) {
            Preconditions.checkArgument(tmpIns != null);
            try (ObjectReader tmpReader = tmpIns.newReader();){
                RevWalk tmpRw = new RevWalk(tmpReader);
                try {
                    RevCommit revCommit = tmpRw.parseCommit(tmpIns.insert(cb));
                    tmpRw.close();
                    return revCommit;
                }
                catch (Throwable throwable) {
                    try {
                        tmpRw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        Preconditions.checkArgument(tmpIns == null);
        Preconditions.checkArgument(!(ins instanceof InMemoryInserter));
        ObjectId commitId = ins.insert(cb);
        ins.flush();
        RefUpdate ru = repo.updateRef(refName);
        ru.setNewObjectId(commitId);
        ru.disableRefLog();
        ru.forceUpdate();
        return rw.parseCommit(commitId);
    }

    private static class NonFlushingWrapper
    extends ObjectInserter.Filter {
        private final ObjectInserter ins;

        private NonFlushingWrapper(ObjectInserter ins) {
            this.ins = ins;
        }

        @Override
        protected ObjectInserter delegate() {
            return this.ins;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

