/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.projects.DashboardInfo;
import com.google.gerrit.extensions.api.projects.DashboardSectionInfo;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.UrlEncoded;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.DashboardResource;
import com.google.gerrit.server.project.ListDashboards;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.SetDefaultDashboard;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class DashboardsCollection
implements ChildCollection<ProjectResource, DashboardResource>,
AcceptsCreate<ProjectResource> {
    public static final String DEFAULT_DASHBOARD_NAME = "default";
    private final GitRepositoryManager gitManager;
    private final DynamicMap<RestView<DashboardResource>> views;
    private final Provider<ListDashboards> list;
    private final Provider<SetDefaultDashboard.CreateDefault> createDefault;
    private final PermissionBackend permissionBackend;

    @Inject
    DashboardsCollection(GitRepositoryManager gitManager, DynamicMap<RestView<DashboardResource>> views, Provider<ListDashboards> list, Provider<SetDefaultDashboard.CreateDefault> createDefault, PermissionBackend permissionBackend) {
        this.gitManager = gitManager;
        this.views = views;
        this.list = list;
        this.createDefault = createDefault;
        this.permissionBackend = permissionBackend;
    }

    public static boolean isDefaultDashboard(@Nullable String id) {
        return DEFAULT_DASHBOARD_NAME.equals(id);
    }

    public static boolean isDefaultDashboard(@Nullable IdString id) {
        return id != null && DashboardsCollection.isDefaultDashboard(id.toString());
    }

    @Override
    public RestView<ProjectResource> list() throws ResourceNotFoundException {
        return this.list.get();
    }

    @Override
    public RestModifyView<ProjectResource, ?> create(ProjectResource parent, IdString id) throws RestApiException {
        if (DashboardsCollection.isDefaultDashboard(id)) {
            return this.createDefault.get();
        }
        throw new ResourceNotFoundException(id);
    }

    @Override
    public DashboardResource parse(ProjectResource parent, IdString id) throws ResourceNotFoundException, IOException, ConfigInvalidException, PermissionBackendException {
        DashboardInfo info;
        ProjectControl myCtl = parent.getControl();
        if (DashboardsCollection.isDefaultDashboard(id)) {
            return DashboardResource.projectDefault(myCtl);
        }
        try {
            info = DashboardsCollection.newDashboardInfo(id.get());
        }
        catch (InvalidDashboardId e) {
            throw new ResourceNotFoundException(id);
        }
        CurrentUser user = myCtl.getUser();
        for (ProjectState ps : myCtl.getProjectState().tree()) {
            try {
                return this.parse(ps.controlFor(user), info, myCtl);
            }
            catch (AmbiguousObjectException | ConfigInvalidException | IncorrectObjectTypeException e) {
                throw new ResourceNotFoundException(id);
            }
            catch (ResourceNotFoundException e) {
            }
        }
        throw new ResourceNotFoundException(id);
    }

    public static String normalizeDashboardRef(String ref) {
        if (!ref.startsWith("refs/meta/dashboards/")) {
            return "refs/meta/dashboards/" + ref;
        }
        return ref;
    }

    private DashboardResource parse(ProjectControl ctl, DashboardInfo info, ProjectControl myCtl) throws ResourceNotFoundException, IOException, AmbiguousObjectException, IncorrectObjectTypeException, ConfigInvalidException, PermissionBackendException {
        String ref = DashboardsCollection.normalizeDashboardRef(info.ref);
        try {
            this.permissionBackend.user(ctl.getUser()).project(ctl.getProject().getNameKey()).ref(ref).check(RefPermission.READ);
        }
        catch (AuthException e) {
            throw new ResourceNotFoundException(info.id);
        }
        if (!Repository.isValidRefName(ref)) {
            throw new ResourceNotFoundException(info.id);
        }
        Repository git = this.gitManager.openRepository(ctl.getProject().getNameKey());
        try {
            ObjectId objId = git.resolve(ref + ":" + info.path);
            if (objId == null) {
                throw new ResourceNotFoundException(info.id);
            }
            BlobBasedConfig cfg = new BlobBasedConfig(null, git, objId);
            DashboardResource dashboardResource = new DashboardResource(myCtl, ref, info.path, cfg, false);
            if (git != null) {
                git.close();
            }
            return dashboardResource;
        }
        catch (Throwable throwable) {
            try {
                if (git != null) {
                    try {
                        git.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RepositoryNotFoundException e) {
                throw new ResourceNotFoundException(info.id);
            }
        }
    }

    @Override
    public DynamicMap<RestView<DashboardResource>> views() {
        return this.views;
    }

    public static DashboardInfo newDashboardInfo(String ref, String path) {
        DashboardInfo info = new DashboardInfo();
        info.ref = ref;
        info.path = path;
        info.id = Joiner.on(':').join(Url.encode(ref), Url.encode(path), new Object[0]);
        return info;
    }

    static DashboardInfo newDashboardInfo(String id) throws InvalidDashboardId {
        DashboardInfo info = new DashboardInfo();
        ArrayList<String> parts = Lists.newArrayList(Splitter.on(':').limit(2).split(id));
        if (parts.size() != 2) {
            throw new InvalidDashboardId(id);
        }
        info.id = id;
        info.ref = (String)parts.get(0);
        info.path = (String)parts.get(1);
        return info;
    }

    static DashboardInfo parse(Project definingProject, String refName, String path, Config config, String project, boolean setDefault) {
        DashboardInfo info = DashboardsCollection.newDashboardInfo(refName, path);
        info.project = project;
        info.definingProject = definingProject.getName();
        String query = config.getString("dashboard", null, "title");
        info.title = DashboardsCollection.replace(project, query == null ? info.path : query);
        info.description = DashboardsCollection.replace(project, config.getString("dashboard", null, "description"));
        info.foreach = config.getString("dashboard", null, "foreach");
        if (setDefault) {
            String id = refName + ":" + path;
            info.isDefault = id.equals(DashboardsCollection.defaultOf(definingProject)) ? Boolean.valueOf(true) : null;
        }
        UrlEncoded u = new UrlEncoded("/dashboard/");
        u.put("title", MoreObjects.firstNonNull(info.title, info.path));
        if (info.foreach != null) {
            u.put("foreach", DashboardsCollection.replace(project, info.foreach));
        }
        for (String name : config.getSubsections("section")) {
            DashboardSectionInfo s = new DashboardSectionInfo();
            s.name = name;
            s.query = config.getString("section", name, "query");
            u.put(s.name, DashboardsCollection.replace(project, s.query));
            info.sections.add(s);
        }
        info.url = u.toString().replace("%3A", ":");
        return info;
    }

    private static String replace(String project, String query) {
        return query.replace("${project}", project);
    }

    private static String defaultOf(Project proj) {
        String defaultId = MoreObjects.firstNonNull(proj.getLocalDefaultDashboard(), Strings.nullToEmpty(proj.getDefaultDashboard()));
        if (defaultId.startsWith("refs/meta/dashboards/")) {
            return defaultId.substring("refs/meta/dashboards/".length());
        }
        return defaultId;
    }

    public static class InvalidDashboardId
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidDashboardId(String id) {
            super(id);
        }
    }
}

