/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.strategy.SubmitDryRun;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeOperatorPredicate;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gerrit.server.query.change.ConflictKey;
import com.google.gerrit.server.query.change.EqualsPathPredicate;
import com.google.gerrit.server.query.change.LegacyChangeIdPredicate;
import com.google.gerrit.server.query.change.ProjectPredicate;
import com.google.gerrit.server.query.change.RefPredicate;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ConflictsPredicate {
    protected static final String TOO_MANY_FILES = "too many files to find conflicts";

    private ConflictsPredicate() {
    }

    public static Predicate<ChangeData> create(ChangeQueryBuilder.Arguments args, String value, Change c) throws QueryParseException, OrmException {
        List<String> files;
        ChangeData cd;
        try {
            cd = args.changeDataFactory.create(args.db.get(), c);
            files = cd.currentFilePaths();
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
        if (3 + files.size() > args.indexConfig.maxTerms()) {
            throw new QueryParseException(TOO_MANY_FILES);
        }
        ArrayList<EqualsPathPredicate> filePredicates = new ArrayList<EqualsPathPredicate>(files.size());
        for (String file : files) {
            filePredicates.add(new EqualsPathPredicate("path", file));
        }
        ArrayList and = new ArrayList(5);
        and.add(new ProjectPredicate(c.getProject().get()));
        and.add(new RefPredicate(c.getDest().get()));
        and.add(Predicate.not(new LegacyChangeIdPredicate(c.getId())));
        and.add(Predicate.or(filePredicates));
        ChangeDataCache changeDataCache = new ChangeDataCache(cd, args.projectCache);
        and.add(new CheckConflict("conflicts", value, args, c, changeDataCache));
        return Predicate.and(and);
    }

    private static class ChangeDataCache {
        private final ChangeData cd;
        private final ProjectCache projectCache;
        private ObjectId testAgainst;
        private ProjectState projectState;
        private Set<ObjectId> alreadyAccepted;

        ChangeDataCache(ChangeData cd, ProjectCache projectCache) {
            this.cd = cd;
            this.projectCache = projectCache;
        }

        ObjectId getTestAgainst() throws OrmException {
            if (this.testAgainst == null) {
                this.testAgainst = ObjectId.fromString(this.cd.currentPatchSet().getRevision().get());
            }
            return this.testAgainst;
        }

        ProjectState getProjectState() throws NoSuchProjectException {
            if (this.projectState == null) {
                this.projectState = this.projectCache.get(this.cd.project());
                if (this.projectState == null) {
                    throw new NoSuchProjectException(this.cd.project());
                }
            }
            return this.projectState;
        }

        Set<ObjectId> getAlreadyAccepted(Repository repo) throws IOException {
            if (this.alreadyAccepted == null) {
                this.alreadyAccepted = SubmitDryRun.getAlreadyAccepted(repo);
            }
            return this.alreadyAccepted;
        }
    }

    private static final class CheckConflict
    extends ChangeOperatorPredicate {
        private final ChangeQueryBuilder.Arguments args;
        private final Branch.NameKey dest;
        private final ChangeDataCache changeDataCache;

        CheckConflict(String field, String value, ChangeQueryBuilder.Arguments args, Change c, ChangeDataCache changeDataCache) {
            super(field, value);
            this.args = args;
            this.dest = c.getDest();
            this.changeDataCache = changeDataCache;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean match(ChangeData object) throws OrmException {
            ProjectState projectState;
            Change otherChange = object.change();
            if (otherChange == null || !otherChange.getDest().equals(this.dest)) {
                return false;
            }
            SubmitTypeRecord str = object.submitTypeRecord();
            if (!str.isOk()) {
                return false;
            }
            try {
                projectState = this.changeDataCache.getProjectState();
            }
            catch (NoSuchProjectException e) {
                return false;
            }
            ObjectId other = ObjectId.fromString(object.currentPatchSet().getRevision().get());
            ConflictKey conflictsKey = new ConflictKey(this.changeDataCache.getTestAgainst(), other, str.type, projectState.isUseContentMerge());
            Boolean conflicts = this.args.conflictsCache.getIfPresent(conflictsKey);
            if (conflicts != null) {
                return conflicts;
            }
            try (Repository repo = this.args.repoManager.openRepository(otherChange.getProject());){
                boolean bl;
                block19: {
                    CodeReviewCommit.CodeReviewRevWalk rw = CodeReviewCommit.newRevWalk(repo);
                    try {
                        conflicts = !this.args.submitDryRun.run(str.type, repo, rw, otherChange.getDest(), this.changeDataCache.getTestAgainst(), other, this.getAlreadyAccepted(repo, rw));
                        this.args.conflictsCache.put(conflictsKey, conflicts);
                        bl = conflicts;
                        if (rw == null) break block19;
                    }
                    catch (Throwable throwable) {
                        if (rw != null) {
                            try {
                                rw.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rw.close();
                }
                return bl;
            }
            catch (IntegrationException | NoSuchProjectException | IOException e) {
                throw new OrmException(e);
            }
        }

        @Override
        public int getCost() {
            return 5;
        }

        private Set<RevCommit> getAlreadyAccepted(Repository repo, RevWalk rw) throws IntegrationException {
            try {
                HashSet<RevCommit> accepted = new HashSet<RevCommit>();
                SubmitDryRun.addCommits(this.changeDataCache.getAlreadyAccepted(repo), rw, accepted);
                ObjectId tip = this.changeDataCache.getTestAgainst();
                if (tip != null) {
                    accepted.add(rw.parseCommit(tip));
                }
                return accepted;
            }
            catch (OrmException | IOException e) {
                throw new IntegrationException("Failed to determine already accepted commits.", e);
            }
        }
    }
}

