/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Ordering;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.VersionedAuthorizedKeys;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_123;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

public class Schema_124
extends SchemaVersion {
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final PersonIdent serverUser;

    @Inject
    Schema_124(Provider<Schema_123> prior, GitRepositoryManager repoManager, AllUsersName allUsersName, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        Multimap imports = MultimapBuilder.hashKeys().arrayListValues().build();
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();
             ResultSet rs = stmt.executeQuery("SELECT account_id, seq, ssh_public_key, valid FROM account_ssh_keys");){
            while (rs.next()) {
                Account.Id accountId = new Account.Id(rs.getInt(1));
                int seq = rs.getInt(2);
                String sshPublicKey = rs.getString(3);
                AccountSshKey key = new AccountSshKey(new AccountSshKey.Id(accountId, seq), sshPublicKey);
                boolean valid = Schema_124.toBoolean(rs.getString(4));
                if (!valid) {
                    key.setInvalid();
                }
                imports.put(accountId, key);
            }
        }
        if (imports.isEmpty()) {
            return;
        }
        try (Repository git = this.repoManager.openRepository(this.allUsersName);
             RevWalk rw = new RevWalk(git);){
            BatchRefUpdate bru = git.getRefDatabase().newBatchUpdate();
            for (Map.Entry e : imports.asMap().entrySet()) {
                try (MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allUsersName, git, bru);){
                    md.getCommitBuilder().setAuthor(this.serverUser);
                    md.getCommitBuilder().setCommitter(this.serverUser);
                    VersionedAuthorizedKeys authorizedKeys = new VersionedAuthorizedKeys(new VersionedAuthorizedKeys.SimpleSshKeyCreator(), (Account.Id)e.getKey());
                    authorizedKeys.load(md);
                    authorizedKeys.setKeys(this.fixInvalidSequenceNumbers(e.getValue()));
                    authorizedKeys.commit(md);
                }
            }
            bru.execute(rw, NullProgressMonitor.INSTANCE);
        }
        catch (IOException | ConfigInvalidException ex) {
            throw new OrmException(ex);
        }
    }

    private Collection<AccountSshKey> fixInvalidSequenceNumbers(Collection<AccountSshKey> keys) {
        Ordering<AccountSshKey> o = Ordering.from(Comparator.comparing(k -> k.getKey().get()));
        ArrayList<AccountSshKey> fixedKeys = new ArrayList<AccountSshKey>(keys);
        AccountSshKey minKey = o.min(keys);
        while (minKey.getKey().get() <= 0) {
            AccountSshKey fixedKey = new AccountSshKey(new AccountSshKey.Id(minKey.getKey().getParentKey(), Math.max(o.max(keys).getKey().get() + 1, 1)), minKey.getSshPublicKey());
            Collections.replaceAll(fixedKeys, minKey, fixedKey);
            minKey = o.min(fixedKeys);
        }
        return fixedKeys;
    }

    private static boolean toBoolean(String v) {
        return !Strings.isNullOrEmpty(v) && v.equalsIgnoreCase("Y");
    }
}

