/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_134;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

public class Schema_135
extends SchemaVersion {
    private static final String COMMIT_MSG = "Allow admins and project owners to create refs/meta/config";
    private final GitRepositoryManager repoManager;
    private final AllProjectsName allProjectsName;
    private final SystemGroupBackend systemGroupBackend;
    private final PersonIdent serverUser;

    @Inject
    Schema_135(Provider<Schema_134> prior, GitRepositoryManager repoManager, AllProjectsName allProjectsName, SystemGroupBackend systemGroupBackend, @GerritPersonIdent PersonIdent serverUser) {
        super(prior);
        this.repoManager = repoManager;
        this.allProjectsName = allProjectsName;
        this.systemGroupBackend = systemGroupBackend;
        this.serverUser = serverUser;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        try (Repository git = this.repoManager.openRepository(this.allProjectsName);
             MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allProjectsName, git);){
            ProjectConfig config = ProjectConfig.read(md);
            AccessSection meta = config.getAccessSection("refs/meta/config", true);
            Permission createRefsMetaConfigPermission = meta.getPermission("create", true);
            Set groups = Stream.concat(config.getAccessSection("GLOBAL_CAPABILITIES", true).getPermission("administrateServer", true).getRules().stream().map(PermissionRule::getGroup), Stream.of(this.systemGroupBackend.getGroup(SystemGroupBackend.PROJECT_OWNERS))).filter(g -> createRefsMetaConfigPermission.getRule((GroupReference)g) == null).collect(Collectors.toSet());
            for (GroupReference group : groups) {
                createRefsMetaConfigPermission.add(new PermissionRule(config.resolve(group)));
            }
            md.getCommitBuilder().setAuthor(this.serverUser);
            md.getCommitBuilder().setCommitter(this.serverUser);
            md.setMessage(COMMIT_MSG);
            config.commit(md);
        }
        catch (IOException | ConfigInvalidException ex) {
            throw new OrmException(ex);
        }
    }
}

